/* Copyright (C) 2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */


#include "myx_grt_private.h"



typedef struct MYX_GRT_FUNCTION_PRIVATE
{
  MYX_GRT_VALUE *(*function)(MYX_GRT_VALUE*,void*);
} MYX_BUILTIN_FUNCTION;


static MYX_GRT_ERROR c_call_function(MYX_GRT_FUNCTION *function, MYX_GRT_VALUE *value, MYX_GRT_VALUE **retval);


MYX_GRT_MODULE_LOADER *myx_builtin_init_loader(MYX_GRT *grt)
{
  MYX_GRT_MODULE_LOADER *loader= g_new0(MYX_GRT_MODULE_LOADER, 1);

  loader->grt= grt;
  loader->loader_type= MYX_BUILTIN_MODULE_TYPE;
  loader->priv= NULL;
  loader->init_module= NULL;
  loader->call_function= c_call_function;
  loader->extensions_num= 0;
  loader->extensions= NULL;

  return loader;
}


MYX_GRT_ERROR myx_grt_module_register_builtin(MYX_GRT *grt, MYX_GRT_BUILTIN_MODULE *mod, void *function_data)
{
  MYX_GRT_MODULE *module;
  unsigned int i;

  // init internal module descriptor
  module= g_new0(MYX_GRT_MODULE, 1);

  module->loader= myx_grt_get_loader_of_type(grt, MYX_BUILTIN_MODULE_TYPE);
  module->priv= function_data;
  module->name= g_strdup(mod->name);
  module->path= NULL;
  module->functions_num= mod->functions_num;
  module->functions= g_new0(MYX_GRT_FUNCTION, module->functions_num);
  for (i= 0; i < mod->functions_num; i++)
  {
    MYX_GRT_FUNCTION *func= module->functions+i;
    MYX_BUILTIN_FUNCTION *bf= g_new0(MYX_BUILTIN_FUNCTION,1);

    bf->function= mod->functions[i].function;

    func->module= module;
    myx_grt_parse_function_spec(mod->functions[i].name, func);
    func->priv= bf;
  }
  module->extends= g_strdup(mod->extends);
  
  if (getenv("GRT_VERBOSE"))
    g_message("Initialized module %s", mod->name);

  return myx_grt_add_module(grt, module);
}


static MYX_GRT_ERROR c_call_function(MYX_GRT_FUNCTION *function, MYX_GRT_VALUE *value, MYX_GRT_VALUE **retval)
{
  MYX_BUILTIN_FUNCTION *bfunc= (MYX_BUILTIN_FUNCTION*)function->priv;
  MYX_GRT_ERROR error= MYX_GRT_NO_ERROR;
  MYX_GRT_VALUE *func_value= value;

  if ( (myx_grt_value_get_type(value) == MYX_LIST_VALUE) && (myx_grt_list_item_count(value)>0) )
  {
    MYX_GRT_VALUE *first_param= myx_grt_list_item_get(value, 0);

    if ( (myx_grt_value_get_type(first_param) == MYX_STRING_VALUE) && 
        str_beginswith(myx_grt_value_as_string(first_param), "global::") )
    {
      const char *path= myx_grt_value_as_string(first_param)+8;

      func_value= myx_grt_value_get_by_path(
        myx_grt_get_root((MYX_GRT *)(function->module->priv)), path);
    }
  }

  
  if (getenv("GRT_VERBOSE"))
    g_message("Calling builtin function %s.%s", function->module->name, function->name);

  *retval= (*bfunc->function)(func_value, function->module->priv);

  return error;
}
