REM CommandInterpreter: $(COMSPEC)
@echo off

rem ------------------------------
rem create directories

echo Create runtime image directories ...
if not exist ..\..\temp mkdir ..\..\temp

if not exist ..\bin mkdir ..\bin
if not exist ..\bin\windows mkdir ..\bin\windows
if not exist ..\bin\windows\xml mkdir ..\bin\windows\xml
if not exist ..\bin\windows\doc mkdir ..\bin\windows\doc
if not exist ..\bin\windows\fonts mkdir ..\bin\windows\fonts
echo .

rem ------------------------------
rem copy appropriate licence

echo Copying licence files ...
if exist ..\bin\windows\COPYING del ..\bin\windows\COPYING
if exist ..\bin\windows\MySQLEULA.txt del ..\bin\windows\MySQLEULA.txt

copy ..\..\mysql-gui-common\res\COPYING ..\bin\windows\COPYING
echo .

rem ------------------------------
rem copy dlls

echo Copying MySQL Client library
copy ..\..\mysql-gui-win-res\lib\mysql\libmysql.dll ..\bin\windows\libmysql.dll
echo .

echo Copying glib-2.0 libraries
copy ..\..\mysql-gui-win-res\lib\glib-2.0\intl.dll ..\bin\windows\intl.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libglib-2.0-0.dll ..\bin\windows\libglib-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgmodule-2.0-0.dll ..\bin\windows\libgmodule-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgobject-2.0-0.dll ..\bin\windows\libgobject-2.0-0.dll
copy ..\..\mysql-gui-win-res\lib\glib-2.0\libgthread-2.0-0.dll ..\bin\windows\libgthread-2.0-0.dll
echo .

echo Copying libxml2 libraries
copy ..\..\mysql-gui-win-res\lib\libxml\iconv.dll ..\bin\windows\iconv.dll
copy ..\..\mysql-gui-win-res\lib\libxml\libxml2.dll ..\bin\windows\libxml2.dll
copy ..\..\mysql-gui-win-res\lib\libxml\zlib.dll ..\bin\windows\zlib.dll
echo .

rem ------------------------------
rem copy xml files

echo Copying XML files
copy ..\..\mysql-gui-common\res\mysqlx_dbm_charsets.xml ..\bin\windows\xml\mysqlx_dbm_charsets.xml
copy ..\..\mysql-gui-common\res\mysqlx_dbm_datatypes.xml ..\bin\windows\xml\mysqlx_dbm_datatypes.xml

copy ..\res\mysqlqb_functions.xml ..\bin\windows\xml\mysqlqb_functions.xml
copy ..\res\mysqlqb_statements.xml ..\bin\windows\xml\mysqlqb_statements.xml
echo .

rem ------------------------------
rem copy docs

echo Copying doc files
copy ..\res\doc\main.css ..\bin\windows\doc\main.css
copy ..\res\doc\mysqlqb_functions.html ..\bin\windows\doc\mysqlqb_functions.html
copy ..\res\doc\mysqlqb_statements.html ..\bin\windows\doc\mysqlqb_statements.html
copy ..\res\doc\mysqlqb_quickstart.html ..\bin\windows\doc\mysqlqb_quickstart.html

copy ..\doc\mysqlquerybrowser.chm ..\bin\windows\mysqlquerybrowser.chm
echo .

rem ------------------------------
rem copy fonts

echo Copying doc files
copy ..\res\fonts\VeraMoBd.ttf ..\bin\windows\fonts\VeraMoBd.ttf
copy ..\res\fonts\VeraMoBI.ttf ..\bin\windows\fonts\VeraMoBI.ttf
copy ..\res\fonts\VeraMoIt.ttf ..\bin\windows\fonts\VeraMoIt.ttf
copy ..\res\fonts\VeraMono.ttf ..\bin\windows\fonts\VeraMono.ttf
echo .
