<?php
# $Id: hostgroups.php,v 1.6 2002/06/22 06:29:49 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","hostgroup");
define("PAGE_TITLE","Hostgroups");
define("OBJECTTYPE","hostgroup");

require_once("local.inc");
include_once(NGT_LIB."head.inc");

$alter = '';
$rows = array();
$errmsg = '';
$message = '';
$objects = PluginGetObjects(OBJECTTYPE);

if( is_array($objects) ) {
        uasort($objects,"NagiosUasortObjectName");
	foreach($objects as $key => $object) {

		$alter = ($alter != "alter1") ? "alter1" : "alter2";

		$name = isset($object[OBJECTTYPE.'_name']) 
			? $object[OBJECTTYPE.'_name'] : $object['name'];
		$alias = $object['alias'];

		# Is this a inheritable object?
		$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
		if( !empty($object['name']) ) {
			$cntinh = NagiosCountInherited(OBJECTTYPE,$name);
			$inheritance = 'used by '.$cntinh.' objects';
		} else if( !empty($object['use']) ) {
			$inheritance = 'uses '.$object['use'];
		} else {
			$inheritance = '';
		}

		$rows[] = <<<HTML
<tr class="$alter">
  <td><a href="hostgroupedit.php?objectid={$key}">Edit</a></td>
  <td>{$object[OBJECTTYPE.'_name']}</td>
  <td>{$name}</td>
  <td>{$alias}</td>
  <td>{$inheritance}</td>
</tr>
HTML;

        } # foreach
} else {
        $message = "No '".OBJECTTYPE."'-objects found.";
}

?>
<table border="0" cellpadding="5" cellspacing="0">
<tr>
  <td colspan="7" align="left">
  <b><?=ErrorMsg($errmsg)?>
  <?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="7">
  <form action="hostgroupedit.php">
  <input type="submit" value="New">
  </form>
  </td>
</tr>
<tr class="rowsep">
  <td>&nbsp;</td>
  <td>Contact Group Name</td>
  <td>Template</td>
  <td>Alias</td>
  <td>Inheritance</td>
</tr>
<?=implode("\n",$rows)?>
</table>

<?
# Beautification
if( !is_array($objects) ) {
        print "<br><br><br><br><br><br><br><br>";
}
include_once(NGT_LIB."tail.inc");
?>
