<?php
# $Id: serviceescalationedit.php,v 1.1 2002/06/21 10:28:45 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","serviceescalationedit");
define("PAGE_TITLE","Service Escalation object");
define("OBJECTTYPE","serviceescalation");

require_once("local.inc");

$action = isset($action) ? strtolower($action) : '';
$message = '';
$object = NULL;
$cntinh = 0;

# Actions before output is send
switch($action) {
	case 'save':
		$saveobject['host_name'] = 
			@implode(",",$saveobject['host_name']);
		$saveobject['hostgroup_name'] = 
			@implode(",",$saveobject['hostgroup_name']);
		$saveobject['contact_groups'] = 
			@implode(",",$saveobject['contact_groups']);

		$objectid = PluginSaveObject($objectid,$saveobject,OBJECTTYPE);
		header("Location: serviceescalations.php");
		exit();
		break;

	case 'delete':
		$objectid = PluginDeleteObject($objectid,OBJECTTYPE);
		header("Location: serviceescalations.php");
		break;
}

include_once(NGT_LIB."head.inc");

if( is_array($object) == FALSE) {
	$object = PluginGetObject($objectid,OBJECTTYPE);
}

# Get a default cfg file if object is new
if( $object['__cfgfile'] == "") {
  $objects = PluginGetObjects(OBJECTTYPE);
  $firstobject = reset($objects);
  $object['__cfgfile'] = $firstobject['__cfgfile'];
}


foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {

	$required = 'label';
	$value = !empty($object[$key]) ? $object[$key] : '';
	$inhhtml = "";
	
	if( isset($object["++".$key]) ) {
	   $inhhtml = "  <td>".$object["++".$key]."</td>";
           $reqclass = 'requiredok';
	} else {
	   $reqclass = 'required';
	}
	
  	$show = NagiosObjPropEdit(OBJECTTYPE,$key,"saveobject[$key]",$value);

	if( empty($object['name']) ) {
		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}

	$rows[$key] = <<<HTML
<tr>
  <td class="label">$key</td>
  <td class="$required" width="3">&nbsp;</td>
  <td class="value">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<form method="post">
<input type="hidden" name="objectid" value="<?=$object['__objectid']?>">

<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="3" align="right">
  <input type="submit" name="action" value="Save">
  <input type="submit" name="action" value="Delete">
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">Properties</td>
<?php
if( !empty($object['use']) ) {
	$parent = PluginGetObjectByName($object['use'],OBJECTTYPE);
  	print <<<HTML
  <td>
  Inherits from 
  <a href="serviceescalationedit.php?objectid={$parent['__objectid']}"><b>{$parent['name']}</b></a>
  </td>
HTML;
}
?>
</tr>
<?=implode("\n", $rows)?>
</table>
</form>

<?php
include_once(NGT_LIB."tail.inc");
?>
