<?php
# $Id: timeperiodedit.php,v 1.6 2002/06/21 10:27:38 kemuri Exp $

/*
 * Copyright (c) 2002 Ypsilon.Net AG, Germany
 *
 * This file is part of Nagat.
 * 
 * Nagat is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Nagat is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Nagat; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

# Page variables
define("PAGE_ID","timeperiodedit");
define("PAGE_TITLE","Timeperiod object");
define("OBJECTTYPE","timeperiod");

require_once("local.inc");

$action = @strtolower($action);
$message = '';

# Actions before output is send
switch($action) {
	case 'save':
		$name = $saveobject['name'] ? 
			$saveobject['name'] : $saveobject[OBJECTTYPE.'_name'];

		# Check data and bailout when there are errors
#		if( $name != $timeperiodname &&
#			NagiosSearchObject(OBJECTTYPE, $nagios_objects, 
#				$name) != NULL ) {
#			$errmsg = "Timeperiod named '$name' already exists.";
#			$object = $saveobject;
#			break;
#		}

		$objectid = PluginSaveObject($objectid,$saveobject,OBJECTTYPE);
		header("Location: timeperiodedit.php?objectid=$objectid");
		exit();
		break;
	case 'delete':
		$objectid = PluginDeleteObject($objectid,OBJECTTYPE);
		header("Location: timeperiods.php");
		break;
}

include_once(NGT_LIB."head.inc");

if( is_array($object) == FALSE) {
	$object = PluginGetObject($objectid,OBJECTTYPE);
}

$timeperiodname = isset($object[OBJECTTYPE."_name"]) ? 
	$object[OBJECTTYPE."_name"] : $object['name']; 
if( !empty($object['name']) ) {
	$cntinh = NagiosCountInherited(OBJECTTYPE,$timeperiodname);
}

if( !empty($object['use']) ) {
	$inhobject = PluginGetObjectByName($object['use'],OBJECTTYPE);
	foreach($inhobject as $key => $value) {
		$object['++'.$key] = $value;
	}
}

# Get a default cfg file if object is new
if( $object['__cfgfile'] == "") {
  $objects = PluginGetObjects(OBJECTTYPE);
  $firstobject = reset($objects);
  $object['__cfgfile'] = $firstobject['__cfgfile'];
}
foreach( $confobjects[OBJECTTYPE] as $key => $propconf ) {

	$required = 'label';
	$value = $object[$key];
	$inhhtml = "";
	
	if( $inhvalue = $object["++".$key] ) {
	   $inhhtml = "  <td>$inhvalue</td>";
           $reqclass = 'requiredok';
	} else {
	   $reqclass = 'required';
	}
	
  	$show = NagiosObjPropEdit(OBJECTTYPE,$key,"saveobject[$key]",$value);

	if( $object['name'] == '' ) {
		$required = $propconf[2] == TRUE ? $reqclass : 'label';
	}

	$rows[$key] = <<<HTML
<tr>
  <td class="label">$key</td>
  <td class="$required" with="3">&nbsp;</td>
  <td class="value">
  $show
  </td>
  $inhhtml
</tr>
HTML;
}

?>
<form method="post">
<input type="hidden" name="timeperiodname" value="<?=$timeperiodname?>">
<input type="hidden" name="objectid" value="<?=$object['__objectid']?>">
<input type="hidden" name="saveobject[__cfgfile]" value="<?=$object['__cfgfile']?>">
<input type="hidden" name="saveobject[__type]" value="<?=$object['__type']?>">

<table cellpadding="3" border="0">
<tr>
  <td colspan="3" align="left">
  <?=ErrorMsg($errmsg)?>
  <b><?=$message?>&nbsp;</b>
  </td>
</tr>
<tr>
  <td colspan="3" align="right">
  <input type="submit" name="action" value="Save">
  <input type="submit" name="action" value="Delete">
  </td>
</tr>
<tr class="rowsep">
  <td colspan="3">Properties</td>
<?php
if( !empty($object['use']) ) {
	$parent = PluginGetObjectByName($object['use'],OBJECTTYPE);
	print <<<HTML
  <td>
  Inherits from 
  <a href="timeperiodedit.php?objectid={$parent['__objectid']}"><b>{$parent['name']}</b></a>
  </td>
HTML;
}
?>
</tr>
<?=implode("\n", $rows)?>
<?

if ( $cntinh > 0 ) {
	print ObjectInheritance($timeperiodname,OBJECTTYPE);
}

$userobjs = NagiosObjectUsage($timeperiodname,OBJECTTYPE);
if ( $userobjs != NULL ) {
	print ObjectUsage($timeperiodname,OBJECTTYPE,$userobjs);
}

?>

</table>
</form>

<?php
include_once(NGT_LIB."tail.inc");
?>
