#!/usr/bin/perl
#******************************************************************************************
#
# MTR.CGI
#
# Program: MTR wrapper for CGI written in PERL
# License: GPL
# Copyright (c) 1999 Gary Berger (berger@marketxt.com)
#
# Last Modified: 11/19/99
#
# Command line: N/A
#
# Description:
#
#
# Dependencies:
#
# This plugin uses the 'mtr' command written by  Matt Kimball <mkimball@xmission.com> along with others to traceroute a path
# using ICMP
#
# License Information:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#*****************************************************************************************/

use CGI qw/:standard :text/;


$query = new CGI;

if(param('host')){
	$host=$query->param('host');
}
if(param('count')){
	$count=$query->param('count');
}else { $count = 1; }


$mtrcommand="mtr --report -c $count ";


print header();
print start_html(-title=>"XT TraceRoute");

open(FILE,"$mtrcommand $host|") || die "Can't open mtr\n";
while(<FILE>){
	$line=$_;
	if($line=~/HOST/){
			$line=~s/(\w+)\s+(\w+)\s+(\w+)\s+(\w+)\s+(\w+)\s+(\w+)\s+(\w+)/\'$1\'\,\'$2\'\,\'$3\'\,\'$4\'\,\'$5\'\,\'$6\'\,\'$7\'/ig;
			@headings=eval($line);
			@rows=th(\@headings);	
	}
	else{
			$line=~s/(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)/\'$1\'\,\'$2\'\,\'$3\'\,\'$4\'\,\'$5\'\,\'$6\'\,\'$7\'/ig;
			push(@rows,td([eval($line)]));	
	}
}

&print_table;

print end_html;


sub print_table{



  print table({-border=>undef},
                caption('MTR'),
                Tr(\@rows)
		);

}


