--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System;
package Shared_Library is
   RTLD_LAZY : constant := 16#00000001#;
   RTLD_NOW : constant := 16#00000002#;
   RTLD_GLOBAL : constant := 16#00000100#;
   subtype Handle_Type is System.Address; --  handle en francais :-)
   subtype Flag_Type is Integer;
   function Open_Library (Library_Name : String;
                          Options : Flag_Type) return Handle_Type;
   function Library_Error return String;
   generic
      type Symbol_Access is private;
   function Library_Symbol (Library : Handle_Type;
                            Symbol_Name : String)
                           return Symbol_Access;

   function Close_Library (Library : Handle_Type) return Integer;
   Library_Loading_Failed : exception;
   Unknown_Symbol : exception;
end Shared_Library;
