--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System.Storage_Elements;

separate (Low_Level_Network.Utils)

function Get_Interfaces return Interfaces_Array is
   Fd : Integer;
   Buffer_Size : constant := 1024;
   Interfaces_Buffer : array (1 .. Buffer_Size) of Interfaces.Unsigned_8;
   Buffer_Address : constant System.Address := Interfaces_Buffer (1)'Address;
   Ifconf : Ifconf_Type := (Buffer_Size, Buffer_Address);
   C_Fct_Return : Integer;
   Interfaces_Number : Natural;
   Offset : System.Storage_Elements.Storage_Offset := 0;
   use type System.Storage_Elements.Storage_Offset;
   use type Interfaces.Unsigned_8;
begin
   Fd := Socket (PF_INET, SOCK_DGRAM, IPPROTO_IP);
   if Fd = -1 then
      raise Bad_Call;
   end if;
   C_Fct_Return := Ioctl (Fd, SIOCGIFCONF, Ifconf'Address);
   if C_Fct_Return = -1 then
      raise Bad_Call;
   end if;
   C_Fct_Return := Close (Fd);
   if C_Fct_Return = -1 then
      raise Bad_Call;
   end if;
   Interfaces_Number := 0;
   if Ifconf.Length = 0 then
      raise Bad_Call;
   end if;
   loop
      declare
         Header_Data : Address_Req_Type;
         for Header_Data'Address use (Buffer_Address + Offset);
      begin
         Offset := Offset + 16 +
           System.Storage_Elements.Storage_Offset (Header_Data.Length);
         if Header_Data.Length = 16 then
            Interfaces_Number := Interfaces_Number + 1;
         end if;
      end;
      exit when Offset =
        System.Storage_Elements.Storage_Offset (Ifconf.Length);
   end loop;
   Offset := 0;
   declare
      Interfaces_To_Return : Interfaces_Array (1 .. Interfaces_Number);
      Name_Index : Positive;
      Array_Index : Positive := 1;
      use Ada.Strings.Unbounded;
   begin
      loop
         declare
            Header_Data : Address_Req_Type;
            for Header_Data'Address use (Buffer_Address + Offset);
         begin
            Offset := Offset + 16 +
              System.Storage_Elements.Storage_Offset (Header_Data.Length);
            if Header_Data.Length = 16 then
               Name_Index := 1;
               loop
                  exit when
                    Header_Data.Interface_Name (Name_Index) = ASCII.NUL;
                  Interfaces_To_Return (Array_Index).Name :=
                    Interfaces_To_Return (Array_Index).Name &
                    Header_Data.Interface_Name (Name_Index);
                  Name_Index := Name_Index + 1;
               end loop;
               Interfaces_To_Return (Array_Index).Address :=
                 (Header_Data.Address (3),
                  Header_Data.Address (4),
                  Header_Data.Address (5),
                  Header_Data.Address (6));
               Array_Index := Array_Index + 1;
            end if;
         end;
         exit when Array_Index > Interfaces_Number;
      end loop;
      return Interfaces_To_Return;
   end;
end Get_Interfaces;
