--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

package body Utils is

   use Ada.Strings.Unbounded;

   -----------------
   -- Date_String --
   -----------------

   function Date_String (Date : in Ada.Calendar.Time) return String is
      Year : constant Ada.Calendar.Year_Number := Ada.Calendar.Year (Date);
      Month : constant Ada.Calendar.Month_Number := Ada.Calendar.Month (Date);
      Day : constant Ada.Calendar.Day_Number := Ada.Calendar.Day (Date);
      Seconds : constant Ada.Calendar.Day_Duration :=
        Ada.Calendar.Seconds (Date);
      Seconds_In_The_Day : constant Natural := Natural (Seconds);
      Hour : constant Natural := Natural (Seconds_In_The_Day / 3600);
      Minutes : constant Natural :=
        Natural ((Seconds_In_The_Day mod 3600) / 60);
      Seconds_In_The_Minute : constant Natural :=
        Natural ((Seconds_In_The_Day mod 60));
      Return_String : Ada.Strings.Unbounded.Unbounded_String;
   begin
      Return_String := Return_String &
        Natural'Image (Hour)(2 .. Natural'Image (Hour)'Last);
      if Minutes < 10 then
         Return_String := Return_String & ":0" &
           Natural'Image (Minutes)(2 .. 2);
      else
         Return_String := Return_String & ":" &
           Natural'Image (Minutes)(2 .. 3);
      end if;
      if Seconds_In_The_Minute < 10 then
         Return_String := Return_String & ":0" &
           Natural'Image (Seconds_In_The_Minute)(2 .. 2);
      else
         Return_String := Return_String & ":" &
           Natural'Image (Seconds_In_The_Minute)(2 .. 3);
      end if;
      if Day < 10 then
         Return_String := Return_String & "-0" & Natural'Image (Day)(2 .. 2);
      else
         Return_String := Return_String & "-" & Natural'Image (Day)(2 .. 3);
      end if;
      if Month < 10 then
         Return_String := Return_String & "-0" & Natural'Image (Month)(2 .. 2);
      else
         Return_String := Return_String & "-" & Natural'Image (Month)(2 .. 3);
      end if;
      Return_String := Return_String & "-" & Natural'Image (Year)(2 .. 5);
      return Ada.Strings.Unbounded.To_String (Return_String);
   end Date_String;


   function Date_String_Bis (Date : in Ada.Calendar.Time) return String is
      Year : constant Ada.Calendar.Year_Number := Ada.Calendar.Year (Date);
      Month : constant Ada.Calendar.Month_Number := Ada.Calendar.Month (Date);
      Day : constant Ada.Calendar.Day_Number := Ada.Calendar.Day (Date);
      Seconds : constant Ada.Calendar.Day_Duration :=
        Ada.Calendar.Seconds (Date);
      Seconds_In_The_Day : constant Natural := Natural (Seconds);
      Hour : constant Natural := Natural (Seconds_In_The_Day / 3600);
      Minutes : constant Natural :=
        Natural ((Seconds_In_The_Day mod 3600) / 60);
      Seconds_In_The_Minute : constant Natural :=
        Natural ((Seconds_In_The_Day mod 60));
      Return_String : Ada.Strings.Unbounded.Unbounded_String;
   begin
      Return_String := Return_String & Natural'Image (Year)(2 .. 5);
      if Month < 10 then
         Return_String := Return_String & "_0" & Natural'Image (Month)(2 .. 2);
      else
         Return_String := Return_String & "_" & Natural'Image (Month)(2 .. 3);
      end if;
      if Day < 10 then
         Return_String := Return_String & "_0" & Natural'Image (Day)(2 .. 2);
      else
         Return_String := Return_String & "_" & Natural'Image (Day)(2 .. 3);
      end if;
      Return_String := Return_String & "_" &
        Natural'Image (Hour)(2 .. Natural'Image (Hour)'Last);
      if Minutes < 10 then
         Return_String := Return_String & ":0" &
           Natural'Image (Minutes)(2 .. 2);
      else
         Return_String := Return_String & ":" &
           Natural'Image (Minutes)(2 .. 3);
      end if;
      if Seconds_In_The_Minute < 10 then
         Return_String := Return_String & ":0" &
           Natural'Image (Seconds_In_The_Minute)(2 .. 2);
      else
         Return_String := Return_String & ":" &
           Natural'Image (Seconds_In_The_Minute)(2 .. 3);
      end if;
      return Ada.Strings.Unbounded.To_String (Return_String);
   end Date_String_Bis;

   function Split (Item : String;
                   Separator : Character) return Types.String_Array is
      Number_Of_Separator : Natural := 0;
   begin
      for I in Item'Range loop
         if Item (I) = Separator then
            Number_Of_Separator := Number_Of_Separator + 1;
         end if;
      end loop;
      declare
         Array_To_Return : Types.String_Array (1 .. Number_Of_Separator + 1);
         Array_Position : Positive := 1;
      begin
         for I in Item'Range loop
            if Item (I) = Separator then
               Array_Position := Array_Position + 1;
            else
               Array_To_Return (Array_Position) :=
                 Array_To_Return (Array_Position) & Item (I);
            end if;
         end loop;
         return Array_To_Return;
      end;
   end Split;



   function Run_Number_Digits (Run_Number : Natural) return String is
      Return_String : Ada.Strings.Unbounded.Unbounded_String;
   begin
      if Run_Number > 99 then
         Return_String := Return_String & Natural'Image (Run_Number)(2 .. 4);
      elsif Run_Number < 100 and Run_Number > 9 then
         Return_String := "0" & Return_String &
           Natural'Image (Run_Number)(2 .. 3);
      elsif Run_Number < 10 then
         Return_String := Return_String & "00" &
           Natural'Image (Run_Number)(2 .. 2);
      end if;
      return Ada.Strings.Unbounded.To_String (Return_String);
   end Run_Number_Digits;

   function Cut_First_Spaces (Item : String) return String is
   begin
      if Item (Item'First) /= ' ' then
         return Item;
      end if;
      for I in Item'Range loop
         if Item (I) /= ' ' then
            return Item (I .. Item'Last);
         end if;
      end loop;
      return "";
   end Cut_First_Spaces;

   function Cut_Last_Spaces (Item : String) return String is
   begin
      if Item (Item'Last) /= ' ' then
         return Item;
      end if;
      for I in reverse Item'Range loop
         if Item (I) /= ' ' then
            return Item (Item'First .. I);
         end if;
      end loop;
      return "";
   end Cut_Last_Spaces;

end Utils;

