--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System;

package body Uuid is

   pragma Linker_Options ("-luuid");

   procedure Uuid_Clear (Uuid_Value : out Uuid_Type) is
      procedure Internal (Address : System.Address);
      pragma Import (C, Internal, "uuid_clear");
   begin
      Internal (Uuid_Value (Uuid_Value'First)'Address);
   end Uuid_Clear;

   -----------
   -- Image --
   -----------

   function Image (Uuid_Value : Uuid_Type) return String is
      procedure Internal (Uuid_Address : System.Address;
                          Address_String_To_Return : System.Address);
      pragma Import (C, Internal, "uuid_unparse");
      String_To_Return : String (1 .. 37);
   begin
      Internal (Uuid_Value (Uuid_Value'First)'Address,
                String_To_Return (String_To_Return'First)'Address);
      return String_To_Return (1 .. 36);
   end Image;

   -------------------
   -- Uuid_Generate --
   -------------------

   procedure Uuid_Generate (Uuid_Value : out Uuid_Type) is
      procedure Internal (Address : System.Address);
      pragma Import (C, Internal, "uuid_generate");
   begin
      Internal (Uuid_Value (Uuid_Value'First)'Address);
   end Uuid_Generate;

   --------------------------
   -- Uuid_Generate_Random --
   --------------------------

   procedure Uuid_Generate_Random (Uuid_Value : out Uuid_Type) is
      procedure Internal (Address : System.Address);
      pragma Import (C, Internal, "uuid_generate_random");
   begin
      Internal (Uuid_Value (Uuid_Value'First)'Address);
   end Uuid_Generate_Random;

   ------------------------
   -- Uuid_Generate_Time --
   ------------------------

   procedure Uuid_Generate_Time (Uuid_Value : out Uuid_Type) is
      procedure Internal (Address : System.Address);
      pragma Import (C, Internal, "uuid_generate_time");
   begin
      Internal (Uuid_Value (Uuid_Value'First)'Address);
   end Uuid_Generate_Time;

end Uuid;
