#include <stdio.h>
#include <assert.h>
#include "info2cap.h"

void printseq(char *s) {

	printf("\"");
	if (s) while(*s) {
		if (isprint(*s)) putchar(*s);
		else printf("\\x%x", *s);

		s++;
	}
	printf("\"");
}

void printvar(int x) {
	printf("%d", x);
}


int main() {

	assert(tgetent(NULL, "pcansi-m") == 1);
	
	column_address = tgetstr("ch", NULL);
	row_address = tgetstr("cv", NULL);

	cursor_address = tgetstr("cm", NULL);

	carriage_return = tgetstr("cr", NULL);

	cursor_home = tgetstr("ho", NULL);
	cursor_to_ll = tgetstr("ll", NULL);

	cursor_right = tgetstr("nd", NULL);

	cursor_down = tgetstr("do", NULL);
	cursor_left = tgetstr("le", NULL);
	cursor_up = tgetstr("up", NULL);

	auto_right_margin = tgetflag("am");
	eat_newline_glitch = tgetflag("xn");

	clr_eos = tgetstr("cd", NULL);
	clear_screen = tgetstr("cl", NULL);

	bell = tgetstr("bl", NULL);
	flash_screen = tgetstr("vb", NULL);

	scroll_forward = tgetstr("sf", NULL);
	scroll_reverse = tgetstr("sr", NULL);

   enter_delete_mode = tgetstr("dm", NULL);
   exit_delete_mode = tgetstr("ed", NULL);
	enter_insert_mode = tgetstr("im", NULL);
	exit_insert_mode = tgetstr("ei", NULL);

	enter_standout_mode = tgetstr("so", NULL);
	exit_standout_mode = tgetstr("se", NULL);
	magic_cookie_glitch = tgetnum("sg");
	move_standout_mode = tgetflag("ms");

	change_scroll_region = tgetstr("cs", NULL);

	insert_line = tgetstr("al", NULL);
	parm_insert_line = tgetstr("AL", NULL);
	delete_line = tgetstr("dl", NULL);
	parm_delete_line = tgetstr("DL", NULL);

	insert_character = tgetstr("ic", NULL);
   parm_ich = tgetstr("IC", NULL);

   insert_padding = tgetstr("ip", NULL);

   delete_character = tgetstr("dc", NULL);
   parm_dch = tgetstr("DC", NULL);

	move_insert_mode = tgetflag("mi");

	cursor_invisible = tgetstr("vi", NULL);
	cursor_normal = tgetstr("ve", NULL);

	init_1string = tgetstr("i1", NULL);
	init_2string = tgetstr("is", NULL);
	init_3string = tgetstr("i3", NULL);

	enter_ca_mode = tgetstr("ti", NULL);
	exit_ca_mode = tgetstr("te", NULL);

	exit_attribute_mode = tgetstr("me", NULL);
	exit_alt_charset_mode = tgetstr("ae", NULL);

	repeat_char = tgetstr("rp", NULL);

	tilde_glitch = tgetflag("hz");
	memory_below = tgetflag("db");

	has_meta_key = tgetflag("km");
	meta_on = tgetstr("mm", NULL);
	meta_off = tgetstr("mo", NULL);

	set_window = tgetstr("wi", NULL);

	keypad_local = tgetstr("ke", NULL);
	keypad_xmit = tgetstr("ks", NULL);

	clr_eol = tgetstr("ce", NULL);
	transparent_underline = tgetflag("ul");

	key_up = tgetstr("ku", NULL);
	key_down = tgetstr("kd", NULL);
	key_left = tgetstr("kl", NULL);
	key_right = tgetstr("kr", NULL);

	key_home = tgetstr("kh", NULL);
	key_end = tgetstr("@7", NULL);

	key_npage = tgetstr("kN", NULL);
	key_ppage = tgetstr("kP", NULL);

	key_sf = tgetstr("kF", NULL);
	key_sr = tgetstr("kR", NULL);


	/* Editing keys */

	key_eol = tgetstr("kE", NULL);
	key_eos = tgetstr("kS", NULL);
	key_backspace = tgetstr("kb", NULL);
	key_dl = tgetstr("kL", NULL);
	key_il = tgetstr("kA", NULL);
	key_dc = tgetstr("kD", NULL);
	key_ic = tgetstr("kI", NULL);
	key_eic = tgetstr("kM", NULL);
	key_clear = tgetstr("kC", NULL);


	/* Keypad keys */

	key_a1 = tgetstr("K1", NULL);
	key_a3 = tgetstr("K2", NULL);
	key_b2 = tgetstr("K3", NULL);
	key_c1 = tgetstr("K4", NULL);
	key_c3 = tgetstr("K5", NULL);


	/* Tab keys (never used in the standard configuration) */

	key_catab = tgetstr("ka", NULL);
	key_ctab = tgetstr("kt", NULL);
	key_stab = tgetstr("kT", NULL);


	/* Function keys */

	key_f0 = key_f10 = tgetstr("k0", NULL);
	key_f1 = tgetstr("k1", NULL);
	key_f2 = tgetstr("k2", NULL);
	key_f3 = tgetstr("k3", NULL);
	key_f4 = tgetstr("k4", NULL);
	key_f5 = tgetstr("k5", NULL);
	key_f6 = tgetstr("k6", NULL);
	key_f7 = tgetstr("k7", NULL);
	key_f8 = tgetstr("k8", NULL);
	key_f9 = tgetstr("k9", NULL);




	printf("column_address = ");
	printseq(column_address);
	printf(";\n");
	printf("row_address = ");
	printseq(row_address);
	printf(";\n");


	printf("cursor_address = ");
	printseq(cursor_address);
	printf(";\n");

	printf("carriage_return = ");
	printseq(carriage_return);
	printf(";\n");

	printf("cursor_home = ");
	printseq(cursor_home);
	printf(";\n");
	printf("cursor_to_ll = ");
	printseq(cursor_to_ll);
	printf(";\n");

	printf("cursor_right = ");
	printseq(cursor_right);
	printf(";\n");

	printf("cursor_down = ");
	printseq(cursor_down);
	printf(";\n");
	printf("cursor_left = ");
	printseq(cursor_left);
	printf(";\n");
	printf("cursor_up = ");
	printseq(cursor_up);
	printf(";\n");

	printf("auto_right_margin = 1\n");
	printf("eat_newline_glitch = 0\n");

	printf("clr_eos = ");
	printseq(clr_eos);
	printf(";\n");
	printf("clear_screen = ");
	printseq(clear_screen);
	printf(";\n");

	printf("bell = ");
	printseq(bell);
	printf(";\n");
	printf("flash_screen = ");
	printseq(flash_screen);
	printf(";\n");

	printf("scroll_forward = ");
	printseq(scroll_forward);
	printf(";\n");
	printf("scroll_reverse = ");
	printseq(scroll_reverse);
	printf(";\n");

	printf("enter_delete_mode = ");
	printseq(enter_delete_mode);
	printf(";\n");
	printf("exit_delete_mode = ");
	printseq(exit_delete_mode);
	printf(";\n");
	printf("enter_insert_mode = ");
	printseq(enter_insert_mode);
	printf(";\n");
	printf("exit_insert_mode = ");
	printseq(exit_insert_mode);
	printf(";\n");

	printf("enter_standout_mode = ");
	printseq(enter_standout_mode);
	printf(";\n");
	printf("exit_standout_mode = ");
	printseq(exit_standout_mode);
	printf(";\n");
	printf("magic_cookie_glitch = 0\n");
	printf("move_standout_mode = 1\n");

	printf("change_scroll_region = ");
	printseq(change_scroll_region);
	printf(";\n");

	printf("insert_line = ");
	printseq(insert_line);
	printf(";\n");
	printf("parm_insert_line = ");
	printseq(parm_insert_line);
	printf(";\n");
	printf("delete_line = ");
	printseq(delete_line);
	printf(";\n");
	printf("parm_delete_line = ");
	printseq(parm_delete_line);
	printf(";\n");

	printf("insert_character = ");
	printseq(insert_character);
	printf(";\n");
	printf("parm_ich = ");
	printseq(parm_ich);
	printf(";\n");

	printf("insert_padding = ");
	printseq(insert_padding);
	printf(";\n");

	printf("delete_character = ");
	printseq(delete_character);
	printf(";\n");
	printf("parm_dch = ");
	printseq(parm_dch);
	printf(";\n");

	printf("move_insert_mode = 1\n");

	printf("cursor_invisible = ");
	printseq(cursor_invisible);
	printf(";\n");
	printf("cursor_normal = ");
	printseq(cursor_normal);
	printf(";\n");

	printf("init_1string = ");
	printseq(init_1string);
	printf(";\n");
	printf("init_2string = ");
	printseq(init_2string);
	printf(";\n");
	printf("init_3string = ");
	printseq(init_3string);
	printf(";\n");

	printf("enter_ca_mode = ");
	printseq(enter_ca_mode);
	printf(";\n");
	printf("exit_ca_mode = ");
	printseq(exit_ca_mode);
	printf(";\n");

	printf("exit_attribute_mode = ");
	printseq(exit_attribute_mode);
	printf(";\n");
	printf("exit_alt_charset_mode = ");
	printseq(exit_alt_charset_mode);
	printf(";\n");

	printf("repeat_char = ");
	printseq(repeat_char);
	printf(";\n");

	printf("tilde_glitch = 0\n");
	printf("memory_below = 0\n");

	printf("has_meta_key = 0\n");
	printf("meta_on = ");
	printseq(meta_on);
	printf(";\n");
	printf("meta_off = ");
	printseq(meta_off);
	printf(";\n");

	printf("set_window = ");
	printseq(set_window);
	printf(";\n");

	printf("keypad_local = ");
	printseq(keypad_local);
	printf(";\n");
	printf("keypad_xmit = ");
	printseq(keypad_xmit);
	printf(";\n");

	printf("clr_eol = ");
	printseq(clr_eol);
	printf(";\n");
	printf("transparent_underline = 0\n");

	printf("key_up = ");
	printseq(key_up);
	printf(";\n");
	printf("key_down = ");
	printseq(key_down);
	printf(";\n");
	printf("key_left = ");
	printseq(key_left);
	printf(";\n");
	printf("key_right = ");
	printseq(key_right);
	printf(";\n");

	printf("key_home = ");
	printseq(key_home);
	printf(";\n");
	printf("key_end = ");
	printseq(key_end);
	printf(";\n");

	printf("key_npage = ");
	printseq(key_npage);
	printf(";\n");
	printf("key_ppage = ");
	printseq(key_ppage);
	printf(";\n");

	printf("key_sf = ");
	printseq(key_sf);
	printf(";\n");
	printf("key_sr = ");
	printseq(key_sr);
	printf(";\n");


	/* Editing keys */

	printf("key_eol = ");
	printseq(key_eol);
	printf(";\n");
	printf("key_eos = ");
	printseq(key_eos);
	printf(";\n");
	printf("key_backspace = ");
	printseq(key_backspace);
	printf(";\n");
	printf("key_dl = ");
	printseq(key_dl);
	printf(";\n");
	printf("key_il = ");
	printseq(key_il);
	printf(";\n");
	printf("key_dc = ");
	printseq(key_dc);
	printf(";\n");
	printf("key_ic = ");
	printseq(key_ic);
	printf(";\n");
	printf("key_eic = ");
	printseq(key_eic);
	printf(";\n");
	printf("key_clear = ");
	printseq(key_clear);
	printf(";\n");


	/* Keypad keys */

	printf("key_a1 = ");
	printseq(key_a1);
	printf(";\n");
	printf("key_a3 = ");
	printseq(key_a3);
	printf(";\n");
	printf("key_b2 = ");
	printseq(key_b2);
	printf(";\n");
	printf("key_c1 = ");
	printseq(key_c1);
	printf(";\n");
	printf("key_c3 = ");
	printseq(key_c3);
	printf(";\n");


	/* Tab keys (never used in the standard configuration) */

	printf("key_catab = ");
	printseq(key_catab);
	printf(";\n");
	printf("key_ctab = ");
	printseq(key_ctab);
	printf(";\n");
	printf("key_stab = ");
	printseq(key_stab);
	printf(";\n");


	/* Function keys */

	printf("key_f0 = key_f10 = ");
	printseq(key_f0 = key_f10);
	printf(";\n");
	printf("key_f1 = ");
	printseq(key_f1);
	printf(";\n");
	printf("key_f2 = ");
	printseq(key_f2);
	printf(";\n");
	printf("key_f3 = ");
	printseq(key_f3);
	printf(";\n");
	printf("key_f4 = ");
	printseq(key_f4);
	printf(";\n");
	printf("key_f5 = ");
	printseq(key_f5);
	printf(";\n");
	printf("key_f6 = ");
	printseq(key_f6);
	printf(";\n");
	printf("key_f7 = ");
	printseq(key_f7);
	printf(";\n");
	printf("key_f8 = ");
	printseq(key_f8);
	printf(";\n");
	printf("key_f9 = ");
	printseq(key_f9);
	printf(";\n");



	return 0;
}
