# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200405-05.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(14491);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200405-05");
 script_cve_id("CAN-2004-0233");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200405-05
(Utempter symlink vulnerability)


    Utempter contains a vulnerability that may allow local users to overwrite
    arbitrary files via a symlink attack.
  
Impact

    This vulnerability may allow arbitrary files to be overwritten with root
    privileges.
  
Workaround

    There is no known workaround at this time. All users are advised to upgrade
    to the latest available version of utempter.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2004-0233


Solution: 
    All users of utempter should upgrade to the latest stable version:
    # emerge sync
    # emerge -pv ">=sys-apps/utempter-0.5.5.4"
    # emerge ">=sys-apps/utempter-0.5.5.4"
  

Risk Factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200405-05] Utempter symlink vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Utempter symlink vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-apps/utempter", unaffected: make_list("ge 0.5.5.4"), vulnerable: make_list("lt 0.5.5.4")
)) { security_warning(0); exit(0); }
