#TRUSTED 3c37af46c4370bcd5a4164ce73221a6f3ab44d0769cc2888233d0444936bc375003c6ab29fb7186ad3ccdd50a3eba68698e4cb1913a9fe31c829a479a1851ce3682c1012c073d3f1d9a823e01b143bd947b50134b47442d6e1c63d81a986d12897a4d1bfb72fa60e5a74e4c1eacb3d8c87a57cc6e881aa8d642ca91d98d890487b0de28782a48e5f7205aa6d3d34fbef27364dcc7fa29b1daa0d069b656681573032eafd0cc35c1ae5c4e3e683f15dfad843800f8de33a01bc066e3a1230235623400374d3baadce6ca27b1f9ce9c7ef17630a6414ed1e8cdc34306ac3e6127d28d5c5a619a86ecd61b5b5322b43577b15787d4e3ca533b2df93bb5ed255333d12a7e23320af49d1cde0d0d01a94a55fe272ea7a4b548886613c3c6e252876b0cb7eba65149490cb41a61d28156bc64b1fea9e8168d8721ffc47fa8e67500cefba286137c5e56ee3816914fb046fea3d94f4ced81c19a22bdbebf29647f65373e16c2518bae26f2ae06a6c82edac0d7db37c45595b8309c0c8caf7fe3cd7623094e14e4a1eacd450aa718bc0437b4890a73fde60af36351369d5314af01a7ff9ccef4cbe8f8c7b9779f3e71a2f37b15959ae99ef8c6f4bee8f865b2ea37bd38ef12cd8d4a6332c7c0bc44facdd674da41b08cedb665e1bf13f02ca5d7ffc003859c965ba344e23929a11ab35782020a7c72aa06f6941a03e87a214194e9ffec3
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15882);
 script_version ("1.1");
 name["english"] = "Hydra: rexec";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find rexec accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force rexec authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/rexecd", 512);
 script_dependencies("hydra_options.nasl", "find_service.nes", "rexecd.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/rexecd");
if (! port) port = 512;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "rexec";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/rexec/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following Rexec accounts:\n' + report);
