#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: gollum <gollum@evilemail.com>
#
#  This script is released under the GNU GPL v2
#

if(description)
{
 script_id(15396);
 script_bugtraq_id(2932);
 script_cve_id("CAN-2001-0784");
 if (defined_func("script_xref")) script_xref(name:"OSVDB", value:"1883");
 script_version ("$Revision: 1.1 $");
 
 name["english"] = "ICECast directory traversal flaw";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote server runs a version of ICECast, an open source 
streaming audio server, which is as older than version 1.3.10.

This version is affected by a directory traversal flaw.

An attacker could send specially crafted URL to view arbitrary files 
on the system.

*** Nessus reports this vulnerability using only
*** information that was gathered.

Solution : Upgrade to a newer version.
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check icecast version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak",
		francais:"Ce script est Copyright (C) 2004 David Maciejak");
		
 family["english"] = "Misc.";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 8000);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_kb_item("Services/www");
if(!port) port = 8000;

if(get_port_state(port))
{
#for now we just test the banner
soc = open_sock_tcp(port);
if(soc)
{
  req = http_head(item:"/", port:port);
  send(socket:soc,data:req);
  r = http_recv(socket:soc);
  close(soc);
  str = strstr(r, "icecast");
  if(str)
  {
    if(ereg(pattern:"icecast/1\.([012]\.|3\.[0-9][^0-9])", string:str))
      security_hole(port);
  }
 }
}
