/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.CTranslation;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.VirtualSpaceManager;
import java.util.LinkedList;
import java.util.Vector;

public class AnimChoreographer {
    VirtualSpaceManager vsm;
    AnimManager am;

    public AnimChoreographer(VirtualSpaceManager v) {
        this.vsm = v;
        this.am = this.vsm.animator;
    }

    public void createCameraSplineAnimation(long duration, Object data, Integer cID) {
        if (this.am.animatedCameras.containsKey(cID) && ((int[])this.am.animatedCameras.get(cID))[0] == 1) {
            this.am.putAsPendingCAnimation(cID, "pos", duration, (short)0, data, null);
        } else {
            if (this.am.animatedCameras.containsKey(cID)) {
                ((int[])this.am.animatedCameras.get((Object)cID))[0] = 1;
            } else {
                int[] tmpA = new int[]{1, 0};
                this.am.animatedCameras.put(cID, tmpA);
            }
            double nbSteps = Math.round(duration / (long)AnimManager.frameTime);
            if (nbSteps > 0.0) {
                Camera c = this.vsm.getCamera(cID);
                CTranslation an = new CTranslation(c, this.am, duration);
                double[][] matrice = new double[][]{{-0.5, 1.5, -1.5, 0.5}, {1.0, -2.5, 2.0, -0.5}, {-0.5, 0.0, 0.5, 0.0}, {0.0, 1.0, 0.0, 0.0}};
                int nbPts = ((Vector)data).size();
                int n = (int)nbSteps / ++nbPts;
                an.steps = new LongPoint[n * (nbPts - 1)];
                LongPoint cam = new LongPoint(c.posx, c.posy);
                LinkedList<LongPoint> ptsTmp = new LinkedList<LongPoint>((Vector)data);
                ptsTmp.addFirst(cam);
                ptsTmp.addFirst(cam);
                ptsTmp.addLast((LongPoint)ptsTmp.getLast());
                LongPoint[] pts = new LongPoint[ptsTmp.size()];
                ptsTmp.toArray(pts);
                double[] tt = new double[4];
                double[] ttt = new double[4];
                for (int i = 0; i < nbPts - 1; ++i) {
                    tt = new double[4];
                    ttt = new double[4];
                    for (int j = 0; j < n; ++j) {
                        int k;
                        float t = (float)j / (float)(n - 1);
                        tt[0] = t * t * t;
                        tt[1] = t * t;
                        tt[2] = t;
                        tt[3] = 1.0;
                        for (k = 0; k < 4; ++k) {
                            ttt[k] = 0.0;
                            for (int l = 0; l < 4; ++l) {
                                int n2 = k;
                                ttt[n2] = ttt[n2] + tt[l] * matrice[l][k];
                            }
                        }
                        double y = 0.0;
                        double x = 0.0;
                        for (k = 0; k < 4; ++k) {
                            x += ttt[k] * (double)pts[k + i].x;
                            y += ttt[k] * (double)pts[k + i].y;
                        }
                        an.steps[i * n + j] = new LongPoint((long)x, (long)y);
                    }
                }
                this.am.animCameraBag.add(an);
                an.start();
            }
        }
    }
}

