/*

Copyright (C) 2000, 2001 Christian Kreibich <kreibich@aciri.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <nd.h>
#include <nd_gui.h>
#include <nd_globals.h>
#include <nd_packet.h>
#include <nd_tracefile.h>
#include <nd_ync_dialog.h>
#include <support.h>


static void
ync_clicked(GtkButton       *button,
	    gpointer         user_data)
{
  GtkWidget *w;
  int fd;
  ND_YNC_Result val = GPOINTER_TO_INT(user_data);
  
  w = GTK_WIDGET(gtk_widget_get_toplevel(GTK_WIDGET(button)));
  fd = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(w), "write_fd"));
  
  write(fd, &val, sizeof(ND_YNC_Result));
  gtk_widget_destroy(w);
}


GtkWidget*
ync_create_dialog (const char *title, const char *message, int write_fd)
{
  GtkWidget *ync_dialog;
  GtkWidget *vbox7;
  GtkWidget *label11;
  GtkWidget *hbox6;
  GtkWidget *hbox7;
  GtkWidget *yes_button;
  GtkWidget *no_button;
  GtkWidget *cancel_button;

  ync_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (ync_dialog), "ync_dialog", ync_dialog);
  gtk_window_set_title (GTK_WINDOW (ync_dialog), title);
  GTK_WINDOW (ync_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_position (GTK_WINDOW (ync_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (ync_dialog), TRUE);
  gtk_window_set_policy (GTK_WINDOW (ync_dialog), FALSE, FALSE, FALSE);

  vbox7 = GTK_DIALOG (ync_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (ync_dialog), "vbox7", vbox7);
  gtk_widget_show (vbox7);

  label11 = gtk_label_new(message);
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (ync_dialog), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (vbox7), label11, TRUE, TRUE, 0);
  gtk_widget_set_usize (label11, 200, 80);

  hbox6 = GTK_DIALOG (ync_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (ync_dialog), "hbox6", hbox6);
  gtk_widget_show (hbox6);
  gtk_container_set_border_width (GTK_CONTAINER (hbox6), 10);

  hbox7 = gtk_hbox_new (TRUE, 10);
  gtk_widget_ref (hbox7);
  gtk_object_set_data_full (GTK_OBJECT (ync_dialog), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (hbox6), hbox7, FALSE, TRUE, 0);

  yes_button = gtk_button_new_with_label (_("Yes"));
  gtk_widget_ref (yes_button);
  gtk_object_set_data_full (GTK_OBJECT (ync_dialog), "yes_button", yes_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (yes_button);
  gtk_box_pack_start (GTK_BOX (hbox7), yes_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (yes_button, GTK_CAN_DEFAULT);

  no_button = gtk_button_new_with_label (_("No"));
  gtk_widget_ref (no_button);
  gtk_object_set_data_full (GTK_OBJECT (ync_dialog), "no_button", no_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (no_button);
  gtk_box_pack_start (GTK_BOX (hbox7), no_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (no_button, GTK_CAN_DEFAULT);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (ync_dialog), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (cancel_button);
  gtk_box_pack_start (GTK_BOX (hbox7), cancel_button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (yes_button), "clicked",
                      GTK_SIGNAL_FUNC (ync_clicked),
                      GINT_TO_POINTER(ND_YES));
  gtk_signal_connect (GTK_OBJECT (no_button), "clicked",
                      GTK_SIGNAL_FUNC (ync_clicked),
                      GINT_TO_POINTER(ND_NO));
  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (ync_clicked),
                      GINT_TO_POINTER(ND_CANCEL));

  gtk_widget_grab_default (yes_button);

  gtk_object_set_data(GTK_OBJECT(ync_dialog), "write_fd",
		      GINT_TO_POINTER(write_fd));

  return (ync_dialog);
}


ND_YNC_Result   
nd_ync_dialog_show(const char *label, const char *message)
{
  int fd[2];
  fd_set fdset;
  GtkWidget *w;
  ND_YNC_Result result;

  /* Set up a pipe -- the dialog callback will write into
     it and therefore cause the select() call below to
     return. The button clicked can then be obtained by
     reading an ND_YNC_Result from the pipe.
  */

  if (pipe(fd) < 0)
    return (ND_CANCEL);

  w = ync_create_dialog(label, message, fd[1]);
  gtk_widget_show(w);

  FD_ZERO(&fdset);
  FD_SET(fd[0], &fdset);

  if (select(fd[0] + 1, &fdset, NULL, NULL, NULL) < 0)
    return (ND_CANCEL);

  if (read(fd[0], &result, sizeof(ND_YNC_Result) != sizeof(ND_YNC_Result)))
    return (ND_CANCEL);

  close(fd[0]);
  close(fd[1]);

  return (result);
}

