
/*-------------------------------------------------------------*/
/* NETWOX_SMBCMD_TYPE_TRANSACTION_Q */

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSCQ_TYPE_UNKNOWN = 0,
  NETWOX_SMBCMDTSCQ_TYPE_NETSHAREENUM
} netwox_smbcmdtscq_type;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdcmn_data parameterdescriptor;
#define NETWOX_SMBCMDTSC_DESCRIPTOR_B13BWZ "B13BWz"
#define NETWOX_SMBCMDTSC_DESCRIPTOR_WRLEH "WrLeh"
  netwox_smbcmdcmn_data returndescriptor;
  netwib_uint16 detaillevel; /* ?, always 1 */
  netwib_uint16 receivebufferlen;
} netwox_smbcmdtscq_netshareenum;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdtscq_type type;
  union {
    netwox_smbcmdtscq_netshareenum netshareenum;
  } value;
} netwox_smbcmdtscq;
typedef const netwox_smbcmdtscq netwox_constsmbcmdtscq;

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscq_init(netwox_smbcmdtscq *psmbcmdtscq);
netwib_err netwox_smbcmdtscq_selecttype(netwox_smbcmdtscq *psmbcmdtscq,
                                        netwox_smbcmdtscq_type type);
netwib_err netwox_smbcmdtscq_setdefault(netwox_smbcmdtscq *psmbcmdtscq);
netwib_err netwox_smbcmdtscq_close(netwox_smbcmdtscq *psmbcmdtscq);

/*-------------------------------------------------------------*/
/* for those 2 functions :
    - don't forget to set isunicode before
    - they suppose query is stored only in first message (most
      of the time, query is small, so this is ok)
*/
netwib_err netwox_smbcmdtscq_encode_smbcmd(netwox_constsmbcmd *psmbcmd,
                                           netwox_smbcmdtscq *psmbcmdtscq);
/* only decode setup/para/data. Other values have to be set by user */
netwib_err netwox_smbcmdtscq_decode_smbcmd(netwox_constsmbcmdtscq *psmbcmdtscq,
                                           netwox_smbcmd *psmbcmd);

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscq_show(netwox_constsmbcmdtscq *psmbcmdtscq,
                                  netwib_buf *pbuf);
