#ifndef NEUTRINO_FILE_BROWSER_H
#define NEUTRINO_FILE_BROWSER_H

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtktreemodel.h>
#include <gtk/gtktreesortable.h>

#define NEUTRINO_TYPE_FILE_BROWSER  (neutrino_file_browser_get_type())
#define NEUTRINO_FILE_BROWSER(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              NEUTRINO_TYPE_FILE_BROWSER, \
                              NeutrinoFileBrowser ) )
#define NEUTRINO_IS_FILE_BROWSER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 NEUTRINO_TYPE_FILE_BROWSER ) )

enum {
	FILE_BROWSER_NAME_COL,
	FILE_BROWSER_ICON_COL,
	FILE_BROWSER_NODE_COL,
	FILE_BROWSER_USER_COL,
	FILE_BROWSER_DATA_COL,
	FILE_BROWSER_URI_COL,
	FILE_BROWSER_MAX_COL
};

typedef enum {
	FILE_BROWSE_NORMAL = 0,
	FILE_BROWSE_FLAT = 1 << 1,
	FILE_BROWSE_RECURSE = 1 << 2,
	FILE_BROWSE_ROOT = 1 << 3
} NeutrinoFileBrowserMode;

typedef struct NeutrinoFileBrowserDetails NeutrinoFileBrowserDetails;

typedef struct  {
	GObject parent_object;

	NeutrinoFileBrowserDetails *details;
} NeutrinoFileBrowser;

typedef struct {
	GObjectClass parent_spot;

	/* emited when we remove a node from the model */
	void (*removed)( NeutrinoFileBrowser *browser,
			 const gchar *uri,
			 GtkTreeIter *it  );

	/* emited when we add a node to the model */
	void (*added)( NeutrinoFileBrowser *browser,
		       const gchar *uri,
		       const gchar *mime_type,
		       GtkTreeIter *it );

	void (*icon_change)( NeutrinoFileBrowser *browser,
				const gchar *uri,
				const gchar *mime_type,
				GtkTreeIter *it );

	/* fired when the theme changes for places where
	 * a NeutrinoFileBrowser is being used just to get icons */
	void (*theme_change)( NeutrinoFileBrowser *browser );
	
} NeutrinoFileBrowserClass;

GType  neutrino_file_browser_get_type( void );
NeutrinoFileBrowser *neutrino_file_browser_new();

/* set the default mode, passing -1 as the mode to other funcs
   causes this to be used */
void neutrino_file_browser_set_mode( NeutrinoFileBrowser *browser,
				   NeutrinoFileBrowserMode mode );

/* made available so a different view can be used if wanted */
GtkTreeModel *neutrino_file_browser_get_model( NeutrinoFileBrowser *browser );

void neutrino_file_browser_scan_directory( NeutrinoFileBrowser *browser,
					 const gchar *uri,
					 int mode );
const gchar* neutrino_file_browser_scan_iter( NeutrinoFileBrowser *browser,
					    GtkTreeIter *iter,
					    int mode );

/* returns a list of filenames from the given list of iterators */
GList *neutrino_file_browser_get_pathnames( NeutrinoFileBrowser *browser,
					  GList *iters, gboolean recurse );

/* give a custom sort function for the browser */
void neutrino_file_browser_set_sort_func( NeutrinoFileBrowser *browser,
					GtkTreeIterCompareFunc func,
					gpointer data );

GdkPixbuf *neutrino_file_browser_get_icon( NeutrinoFileBrowser *browser,
					 const gchar *uri,
					 gint width, gint height,
					 gboolean ignore_cache,
					 gchar **mtype );

#endif
