/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "CA_Handler_ASN1.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(INTERNAL_CA_CERT_SIG) = {
	ASN1_SIMPLE(INTERNAL_CA_CERT_SIG, signature, ASN1_BIT_STRING),
	ASN1_SIMPLE(INTERNAL_CA_CERT_SIG, sig_alg, X509_ALGOR),
}ASN1_SEQUENCE_END(INTERNAL_CA_CERT_SIG)
ASN1_SEQUENCE(INTERNAL_CA_BODY) = {
	ASN1_SIMPLE(INTERNAL_CA_BODY, ca_serial, ASN1_INTEGER),
	ASN1_SIMPLE(INTERNAL_CA_BODY, ca_type, ASN1_INTEGER),
	ASN1_EXP_OPT(INTERNAL_CA_BODY, lastCrl, X509_CRL, 0),
}ASN1_SEQUENCE_END(INTERNAL_CA_BODY)
InternalCaCertSig InternalCaCertSig::EmptyInstance;
bool InternalCaCertSig::set_sigAlg(const X509_ALGOR * c_sigAlg)
{
	if(m_sigAlg)
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)c_sigAlg);
	if(!m_sigAlg)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const X509_ALGOR * InternalCaCertSig::get_sigAlg() const
{
	if(!m_sigAlg)
		((InternalCaCertSig*)this)->m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

X509_ALGOR * InternalCaCertSig::get_sigAlg()
{
	if(!m_sigAlg)
		m_sigAlg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
	return m_sigAlg;
}

bool InternalCaCertSig::set_signature(const ASN1_BIT_STRING * c_signature)
{
	if(m_signature)
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)c_signature);
	if(!m_signature)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

const ASN1_BIT_STRING * InternalCaCertSig::get_signature() const
{
	if(!m_signature)
		((InternalCaCertSig*)this)->m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

ASN1_BIT_STRING * InternalCaCertSig::get_signature()
{
	if(!m_signature)
		m_signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
	return m_signature;
}

bool InternalCaCertSig::to_PEM(mString & PemDatas) const
{
	INTERNAL_CA_CERT_SIG * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toPEM("NEWPKI CERT SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool InternalCaCertSig::from_PEM(const mString & PemDatas)
{
	INTERNAL_CA_CERT_SIG * c_localvar = NULL;
	if(!Private_fromPEM("NEWPKI CERT SIGNATURE", get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, PemDatas))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

InternalCaCertSig::InternalCaCertSig():NewPKIObject()
{
	resetAll();
}

InternalCaCertSig::InternalCaCertSig(const InternalCaCertSig & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

InternalCaCertSig::~InternalCaCertSig()
{
	Clear();
}

void InternalCaCertSig::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalCaCertSig::freeAll()
{
	if(m_sigAlg)
	{
		ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
	}
	if(m_signature)
	{
		ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
	}
}

void InternalCaCertSig::resetAll()
{
	m_sigAlg = NULL;
	m_signature = NULL;
}

bool InternalCaCertSig::load_Datas(const INTERNAL_CA_CERT_SIG * Datas)
{
	Clear();
	if(Datas->sig_alg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), Datas->sig_alg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	if(Datas->signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), Datas->signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalCaCertSig::give_Datas(INTERNAL_CA_CERT_SIG ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_CA_CERT_SIG*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(m_sigAlg)
	{
		if((*Datas)->sig_alg)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->sig_alg, ASN1_ITEM_rptr(X509_ALGOR));
		if(!((*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (ASN1_VALUE*)m_sigAlg)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->sig_alg)
		{
			(*Datas)->sig_alg = (X509_ALGOR*)ASN1_item_new(ASN1_ITEM_rptr(X509_ALGOR));
			if(!(*Datas)->sig_alg)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	if(m_signature)
	{
		if((*Datas)->signature)
			ASN1_item_free((ASN1_VALUE*)(*Datas)->signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		if(!((*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (ASN1_VALUE*)m_signature)))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
	}
	else
	{
		if(!(*Datas)->signature)
		{
			(*Datas)->signature = (ASN1_BIT_STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_BIT_STRING));
			if(!(*Datas)->signature)
			{
				NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
				return false;
			}
		}
	}
	return true;
}

bool InternalCaCertSig::operator=(const InternalCaCertSig & other)
{
	Clear();
	if(other.m_sigAlg)
	{
		if(m_sigAlg)
			ASN1_item_free((ASN1_VALUE*)m_sigAlg, ASN1_ITEM_rptr(X509_ALGOR));
		m_sigAlg = (X509_ALGOR*)ASN1_item_dup(ASN1_ITEM_rptr(X509_ALGOR), (void*)other.m_sigAlg);
		if(!m_sigAlg)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	if(other.m_signature)
	{
		if(m_signature)
			ASN1_item_free((ASN1_VALUE*)m_signature, ASN1_ITEM_rptr(ASN1_BIT_STRING));
		m_signature = (ASN1_BIT_STRING*)ASN1_item_dup(ASN1_ITEM_rptr(ASN1_BIT_STRING), (void*)other.m_signature);
		if(!m_signature)
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalCaCertSig::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_CA_CERT_SIG);
}
InternalCaBody InternalCaBody::EmptyInstance;
bool InternalCaBody::set_caSerial(unsigned long c_caSerial)
{
	m_caSerial = c_caSerial;
	return true;
}

unsigned long InternalCaBody::get_caSerial() const
{
	return m_caSerial;
}

bool InternalCaBody::set_caType(unsigned long c_caType)
{
	m_caType = c_caType;
	return true;
}

unsigned long InternalCaBody::get_caType() const
{
	return m_caType;
}

bool InternalCaBody::set_lastcrl(const PKI_CRL & c_lastcrl)
{
	m_lastcrl = c_lastcrl;
	return true;
}

const PKI_CRL & InternalCaBody::get_lastcrl() const
{
	return m_lastcrl;
}

PKI_CRL & InternalCaBody::get_lastcrl()
{
	return m_lastcrl;
}

bool InternalCaBody::to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const
{
	INTERNAL_CA_BODY * c_localvar = NULL;
	if(!give_Datas(&c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!Private_toSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE*)c_localvar, sig_pkey, crypt_pkey, sig_md, crypt_cypher))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

bool InternalCaBody::from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey)
{
	INTERNAL_CA_BODY * c_localvar = NULL;
	if(!Private_fromSignEncrypt(cryptinfo, get_ASN1_ITEM(), (ASN1_VALUE**)&c_localvar, sig_pkey, crypt_pkey))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!load_Datas(c_localvar))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
		return false;
	}
	ASN1_item_free((ASN1_VALUE*)c_localvar, get_ASN1_ITEM());
	return true;
}

InternalCaBody::InternalCaBody():NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
}

InternalCaBody::InternalCaBody(const InternalCaBody & other):NewPKIObject(), NewPKISignCryptObject()
{
	resetAll();
	*this = other;
}

InternalCaBody::~InternalCaBody()
{
	Clear();
}

void InternalCaBody::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void InternalCaBody::freeAll()
{
}

void InternalCaBody::resetAll()
{
	m_caSerial = 0;
	m_caType = 0;
	m_lastcrl.Clear();
}

bool InternalCaBody::load_Datas(const INTERNAL_CA_BODY * Datas)
{
	Clear();
	if(Datas->ca_serial)
	{
		m_caSerial = ASN1_INTEGER_GET(Datas->ca_serial);
	}
	if(Datas->ca_type)
	{
		m_caType = ASN1_INTEGER_GET(Datas->ca_type);
	}
	if(Datas->lastCrl)
	{
		if(!m_lastcrl.load_Datas(Datas->lastCrl))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	m_isOk=true;
	return true;
}

bool InternalCaBody::give_Datas(INTERNAL_CA_BODY ** Datas) const
{
	if(!(*Datas) && !(*Datas = (INTERNAL_CA_BODY*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->ca_serial && !((*Datas)->ca_serial = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ca_serial, m_caSerial) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ca_serial);
		(*Datas)->ca_serial = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->ca_type && !((*Datas)->ca_type = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->ca_type, m_caType) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->ca_type);
		(*Datas)->ca_type = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(m_lastcrl)
	{
		if(!(*Datas)->lastCrl && !((*Datas)->lastCrl = (X509_CRL*)ASN1_item_new(ASN1_ITEM_rptr(X509_CRL))))
		{
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
			return false;
		}
		if(!m_lastcrl.give_Datas(&(*Datas)->lastCrl))
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->lastCrl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->lastCrl = NULL;
			NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
			return false;
		}
	}
	else
	{
		if((*Datas)->lastCrl)
		{
			ASN1_item_free((ASN1_VALUE*)(*Datas)->lastCrl, ASN1_ITEM_rptr(X509_CRL));
			(*Datas)->lastCrl = NULL;
		}
	}
	return true;
}

bool InternalCaBody::operator=(const InternalCaBody & other)
{
	Clear();
	m_caSerial = other.m_caSerial;
	m_caType = other.m_caType;
	m_lastcrl = other.m_lastcrl;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * InternalCaBody::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(INTERNAL_CA_BODY);
}
