/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Entity_BACKUP.h: interface for the Entity_BACKUP class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_BACKUP_H
#define ENTITY_BACKUP_H


#include "Entity.h"
#include "Entity_BACKUP_ASN1.h"
#include "BackupStore.h"

/*!
	This class represents a Backup Entity
*/
class Entity_BACKUP : public Entity  
{
public:
	void PrintInfo(FILE * out);
	Entity_BACKUP(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_BACKUP();
	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);
private:
	bool PrepareConfToWrite();
	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);
	
	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);

	bool ParseNewConf();
	
	LocalBackupConf myConf;
	BackupStore BackStore;

	DECLARE_COMMAND_PARSER(Entity_BACKUP);
};

#endif
