/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef ENTITY_BACKUP_ASN1_H
#define ENTITY_BACKUP_ASN1_H

#include <mVector.h>
#include <ASN1/NewPKIObject.h>
#include <openssl/asn1.h>
#include "Entity.h"
#include <ASN1/Asn1Helper.h>

/*!
	This structure represent the local conf.
*/
typedef struct st_LOCAL_BACKUP_CONF
{
	ENTITY_CONF * conf;					//!< The conf.
	INTERNAL_PKI_CA * cas;				//!< The PKI internal CA.
}LOCAL_BACKUP_CONF;
DECLARE_ASN1_ITEM(LOCAL_BACKUP_CONF)

/*!
	This structure represent the local conf.
*/
typedef struct st_LOCAL_BACKUP_CONF_BETA4
{
	ENTITY_CONF_BETA4 * conf;			//!< The conf.
	INTERNAL_PKI_CA * cas;				//!< The PKI internal CA.
}LOCAL_BACKUP_CONF_BETA4;
DECLARE_ASN1_ITEM(LOCAL_BACKUP_CONF_BETA4)

/*!
  This class is the representation of LOCAL_BACKUP_CONF
*/
class LocalBackupConf : public NewPKIObject, public LocalEntityConf
{
public:
	/*! \brief This is the constructor.
	 */
	LocalBackupConf();

	/*! \brief This is the constructor.
	 *  \param other [IN] the datas to copy from.
	 */
	LocalBackupConf(const LocalBackupConf & other);

	/*! \brief This is the destructor.
	 */
	~LocalBackupConf();


	/*! \brief This function converts a LOCAL_BACKUP_CONF to a LocalBackupConf.
	 *  \param Datas [IN] the datas to load from.
	 *  \return true on success, false on failure.
	 */
	bool load_Datas(const LOCAL_BACKUP_CONF * Datas);

	/*! \brief This function converts a LocalBackupConf to a LOCAL_BACKUP_CONF.
	 *  \param Datas [OUT] the datas to copy to.
	 *  \return true on success, false on failure.
	 */
	bool give_Datas(LOCAL_BACKUP_CONF ** Datas) const;

	/*! \brief This function clears all the internals.
	 */
	void Clear();

	/*! \brief This function returns the ASN1_ITEM of LOCAL_BACKUP_CONF.
	 *  \return The ASN1_ITEM.
	 */
	static const ASN1_ITEM * get_ASN1_ITEM();

	/*! \brief This function sets INTERNAL_PKI_CA::cas.
	 *  \param c_cas [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_cas(const InternalPkiCa & c_cas);

	/*! \brief This function returns INTERNAL_PKI_CA::cas.
	 *  \return The value of INTERNAL_PKI_CA::cas.
	 */
	const InternalPkiCa & get_cas() const;

	/*! \brief This function returns INTERNAL_PKI_CA::cas.
	 *  \return The value of INTERNAL_PKI_CA::cas.
	 */
	InternalPkiCa & get_cas();


	/*! \brief This function sets ENTITY_CONF::conf.
	 *  \param c_conf [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_conf(const EntityConf & c_conf);

	/*! \brief This function returns ENTITY_CONF::conf.
	 *  \return The value of ENTITY_CONF::conf.
	 */
	const EntityConf & get_conf() const;

	/*! \brief This function returns ENTITY_CONF::conf.
	 *  \return The value of ENTITY_CONF::conf.
	 */
	EntityConf & get_conf();


	/*! \brief This function converts the local instance to a Asn1EncryptSign.
	 *  \param cryptinfo [OUT] The result.
	 *  \param sig_pkey [IN] The signature private key.
	 *  \param crypt_pkey [IN] The encipherment public key.
	 *  \param sig_md [IN] The hash algorythm.
	 *  \param crypt_cypher [IN] The symetrical encipherment hash.
	 *  \return true on success, false on failure.
	 */
	bool to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const;

	/*! \brief This function loads the local instance from a Asn1EncryptSign.
	 *  \param cryptinfo [IN] The signed and crypted datas.
	 *  \param sig_pkey [IN] The signature private key.
	 *  \param crypt_pkey [IN] The encipherment public key.
	 *  \return true on success, false on failure.
	 */
	bool from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey);


	/*! \brief This function copies a LocalBackupConf to another.
	 *  \param other [IN] the datas to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const LocalBackupConf & other);
	/*! \brief This member is an empty instance of LocalBackupConf.
	 */
	static LocalBackupConf EmptyInstance;

private:
	InternalPkiCa m_cas;
	EntityConf m_conf;
	void resetAll();
	void freeAll();
protected:
};


/*!
  This class is the representation of LOCAL_BACKUP_CONF_BETA4
*/
class LocalBackupConfBeta4 : public NewPKIObject, public LocalEntityConfBeta4
{
public:
	/*! \brief This is the constructor.
	 */
	LocalBackupConfBeta4();

	/*! \brief This is the constructor.
	 *  \param other [IN] the datas to copy from.
	 */
	LocalBackupConfBeta4(const LocalBackupConfBeta4 & other);

	/*! \brief This is the destructor.
	 */
	~LocalBackupConfBeta4();


	/*! \brief This function converts a LOCAL_BACKUP_CONF_BETA4 to a LocalBackupConfBeta4.
	 *  \param Datas [IN] the datas to load from.
	 *  \return true on success, false on failure.
	 */
	bool load_Datas(const LOCAL_BACKUP_CONF_BETA4 * Datas);

	/*! \brief This function converts a LocalBackupConfBeta4 to a LOCAL_BACKUP_CONF_BETA4.
	 *  \param Datas [OUT] the datas to copy to.
	 *  \return true on success, false on failure.
	 */
	bool give_Datas(LOCAL_BACKUP_CONF_BETA4 ** Datas) const;

	/*! \brief This function clears all the internals.
	 */
	void Clear();

	/*! \brief This function returns the ASN1_ITEM of LOCAL_BACKUP_CONF_BETA4.
	 *  \return The ASN1_ITEM.
	 */
	static const ASN1_ITEM * get_ASN1_ITEM();

	/*! \brief This function sets INTERNAL_PKI_CA::cas.
	 *  \param c_cas [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_cas(const InternalPkiCa & c_cas);

	/*! \brief This function returns INTERNAL_PKI_CA::cas.
	 *  \return The value of INTERNAL_PKI_CA::cas.
	 */
	const InternalPkiCa & get_cas() const;

	/*! \brief This function returns INTERNAL_PKI_CA::cas.
	 *  \return The value of INTERNAL_PKI_CA::cas.
	 */
	InternalPkiCa & get_cas();


	/*! \brief This function sets ENTITY_CONF_BETA4::conf.
	 *  \param c_conf [IN] the datas.
	 *  \return true on success, false on failure.
	 */
	bool set_conf(const EntityConfBeta4 & c_conf);

	/*! \brief This function returns ENTITY_CONF_BETA4::conf.
	 *  \return The value of ENTITY_CONF_BETA4::conf.
	 */
	const EntityConfBeta4 & get_conf() const;

	/*! \brief This function returns ENTITY_CONF_BETA4::conf.
	 *  \return The value of ENTITY_CONF_BETA4::conf.
	 */
	EntityConfBeta4 & get_conf();


	/*! \brief This function converts the local instance to a Asn1EncryptSign.
	 *  \param cryptinfo [OUT] The result.
	 *  \param sig_pkey [IN] The signature private key.
	 *  \param crypt_pkey [IN] The encipherment public key.
	 *  \param sig_md [IN] The hash algorythm.
	 *  \param crypt_cypher [IN] The symetrical encipherment hash.
	 *  \return true on success, false on failure.
	 */
	bool to_SignEncrypt(Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey, const EVP_MD * sig_md, const EVP_CIPHER * crypt_cypher) const;

	/*! \brief This function loads the local instance from a Asn1EncryptSign.
	 *  \param cryptinfo [IN] The signed and crypted datas.
	 *  \param sig_pkey [IN] The signature private key.
	 *  \param crypt_pkey [IN] The encipherment public key.
	 *  \return true on success, false on failure.
	 */
	bool from_SignEncrypt(const Asn1EncryptSign & cryptinfo, const EVP_PKEY * sig_pkey, const EVP_PKEY * crypt_pkey);


	/*! \brief This function copies a LocalBackupConfBeta4 to another.
	 *  \param other [IN] the datas to copy from.
	 *  \return true on success, false on failure.
	 */
	bool operator=(const LocalBackupConfBeta4 & other);
	/*! \brief This member is an empty instance of LocalBackupConfBeta4.
	 */
	static LocalBackupConfBeta4 EmptyInstance;

private:
	InternalPkiCa m_cas;
	EntityConfBeta4 m_conf;
	void resetAll();
	void freeAll();
protected:
};


#endif // #ifndef ENTITY_BACKUP_ASN1_H
