/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/



// Entity_PKI.h: interface for the Entity_PKI class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_PKI_H
#define ENTITY_PKI_H


#include "Entity.h"
#include "Entity_PKI_ASN1.h"
#include "CA_Handler.h"
#include <mString.h>

/*!
	This enumeration lists the possible return values when updating ACL
*/
typedef enum en_X509_ACL_INIT
{
	X509_ACL_INIT_ERROR		=	-1,		//!< Error setting the ACL
	X509_ACL_INIT_SAME		=	0,		//!< ACL hasn't changed
	X509_ACL_INIT_MODIFIED	=	1		//!< ACL has changed
}X509_ACL_INIT;

/*!
	This enumeration lists the things to update for the entities confs
*/
typedef enum en_ENTITY_CONF_UPDATE
{
	ENTITY_CONF_UPDATE_ALL		=	1,		//!< Update all
	ENTITY_CONF_UPDATE_ACL		=	2,		//!< Update the ACLs
	ENTITY_CONF_UPDATE_CRL		=	4,		//!< Update the CRLs
	ENTITY_CONF_UPDATE_LINKS	=	8,		//!< Update the Links
	ENTITY_CONF_UPDATE_GROUPS	=	16,		//!< Update the Groups
	ENTITY_CONF_UPDATE_ADMINS	=	32		//!< Update the Admins
}ENTITY_CONF_UPDATE;


/*!
	This class represents a PKI Entity
*/
class Entity_PKI : public Entity
{
public:
	void PrintInfo(FILE * out);
	Entity_PKI(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_PKI();

	bool Upgrade(const char * Version);
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Init(const EntitySignatureResp & init_datas);
	bool Load();
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);

private:
	bool SynchronizeEeOnRa(EntityConf & eeConf, const EntityConf & raConf);
	bool PrepareConfToWrite();
	bool RevokePkiUser(unsigned long serial);
	bool CreatePkiUser(const CreatePkiUserRequest & request, CreatePkiUserResponse & response, unsigned long & serial);
	bool RenameGroup(COMMAND_PARAMETERS);
	bool SetGroups(COMMAND_PARAMETERS);
	bool DelGroup(COMMAND_PARAMETERS);
	bool AddGroup(COMMAND_PARAMETERS);
	bool GetGroups(COMMAND_PARAMETERS);
	bool GetEntitiesLinks(COMMAND_PARAMETERS);
	bool SetEntitiesLinks(COMMAND_PARAMETERS);
	bool SetRepositoriesList(COMMAND_PARAMETERS);
	bool GetRepositoriesList(COMMAND_PARAMETERS);
	bool GetConfiguration(COMMAND_PARAMETERS);
	bool SetOfflineState(COMMAND_PARAMETERS);
	bool GetOfflineState(COMMAND_PARAMETERS);
	bool RevokeEntityCert(COMMAND_PARAMETERS);
	bool RevokeUserCert(COMMAND_PARAMETERS);
	bool CreateUser(COMMAND_PARAMETERS);
	bool EnumUsers(COMMAND_PARAMETERS);
	bool EnumEntities(COMMAND_PARAMETERS);
	bool SignEntity(COMMAND_PARAMETERS);
	bool UserUnlockResourse(COMMAND_PARAMETERS);
	bool UserLockResourse(COMMAND_PARAMETERS);
	bool SetEntityMailConf(COMMAND_PARAMETERS);
	bool GetEntityMailConf(COMMAND_PARAMETERS);
	bool SetEntityAcl(COMMAND_PARAMETERS);
	bool GetEntityAcl(COMMAND_PARAMETERS);
	bool GetEntityConf(COMMAND_PARAMETERS);
	bool SetEntityConf(COMMAND_PARAMETERS);
	bool SetEntityAudits(COMMAND_PARAMETERS);
	bool GetEntityAudits(COMMAND_PARAMETERS);
	bool GetEntityLogsType(COMMAND_PARAMETERS);

	
	StoredEntityConf & STORED_ENTITY_CONF_get(mVector< StoredEntityConf > & entities, const PKI_CERT & cert);
	bool EXPORTED_PKI_CONF_get_conf(const X509 * cert, EntityConfCrypted & conf);
	CA_Handler * GetInternalCA(INTERNAL_CA_TYPE Type);

	bool Add_ENTITY_CONF(const mString & EntityName, const X509 * EntityCert, int Type);
	bool Format_CSR(const mString & strCn, const mString & strEmail, const X509_PUBKEY * pubKey, PKI_CSR & csrK, const X509 * parent_cert);
	EntityConf & GetEntityConfiguration(const PKI_CERT & EntityCert);

	X509_ACL_INIT X509_ACL_init(X509Acl & acls, int EntityType);
	
	
	bool DeclarePkiAdminCert(const PKI_CERT & cert, const mString & Email);
	bool ParseNewConf();
	bool UpdateEntityConfs(int What, EntityConf & OneConf = EntityConf::EmptyInstance, bool ForceCryptGen=false);
	bool SynchronizeLinks(EntityConf & currConf);
	bool STORED_ENTITY_CONF_to_name_x509(const StoredEntityConf & conf, mString & name, PKI_CERT & cert);
	bool Private_RevokeEntityCert(unsigned long serial);
	bool CheckRaConf(EntityConfBodyRa & Conf);
	bool CheckRepositoryConf(EntityConfBodyRep & Conf);
	bool CheckCaConf(EntityConfBodyCa & Conf);
	
	void Free_PkiConf();

	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);

	PkiConf pki_conf;

	CA_Handler * RootCa;
	CA_Handler * EntitiesCa;
	CA_Handler * UsersCa;
	CA_Handler * OcspCa;
	PKI_CERT EntityCert;
	PKI_RSA EntityKey;

	bool IsEntityKnown(const mString & Name, int Type);

	bool InternalCA_Create(INTERNAL_CA_TYPE Type, const GenPrivateKey & KeyGen, const X509_NAME * Dn, const char * Cn, int days);
	bool InternalCA_Sign(INTERNAL_CA_TYPE Type, const PKI_CSR & csr, PKI_CERT & ResultCert, int Days, bool check_sig);
	bool InternalCA_SignForceDn(INTERNAL_CA_TYPE Type, const X509_PUBKEY * pubKey, const mString & cn, const mString & email, PKI_CERT & ResultCert);
	bool InternalCA_Revoke(INTERNAL_CA_TYPE Type, unsigned long serial);

	DECLARE_COMMAND_PARSER(Entity_PKI);
};

#endif
