/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// MIME.h: interface for the MIME class.
//
//////////////////////////////////////////////////////////////////////

#ifndef MIME_H
#define MIME_H

#include <mString.h>
#include <PEM_DER.h>
#include <PKI_CERT.h>
#include <mVector.h>

/*!
	The class provides S/MIME and MIME encoding functionnalities
*/
class MIME  
{
public:
	/*! \brief This is the constructor.
	 */
	MIME();

	/*! \brief This is the destructor.
	 */
	virtual ~MIME();

	/*! \brief This function generates a mail body in S/MIME.
	 *  \param ResultSmime [OUT] The result mal body.
	 *  \param Body [IN] The plain text mail body.
	 *  \param Signer [IN] The signer cert.
	 *  \param PrivKey [IN] The signer key.
	 *  \param Others [IN] The parent certs.
	 *  \return true on success, false on failure.
	 */
	bool GenerateSMIME(mString & ResultSmime, const char *Body, const X509 * Signer, const EVP_PKEY * PrivKey, const mVector<PKI_CERT> & Others);

	/*! \brief This function generates a mail body in MIME.
	 *  \param ResultMime [OUT] The result mal body.
	 *  \param Body [IN] The plain text mail body.
	 *  \param Attach [IN] The attachement or NULL.
	 *  \param AttachLen [IN] The length of Attach or 0.
	 *  \param AttachName [IN] The name of the attachement or NULL.
	 *  \param AttachType [IN] The type of the attachement or NULL.
	 *  \return true on success, false on failure.
	 */
	bool GenerateMIME(mString & ResultMime, const char * Body, unsigned char * Attach, unsigned int AttachLen, const char * AttachName, const char * AttachType);
private:
	void Lf2Crlf(mString & Body);
	void GenerateBoundary(char * boundary, int size);
	PEM_DER Encoder;
};

#endif

