/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// PKIX_Central.h: interface for the PKIX_Central class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PKIX_CENTRAL_H
#define PKIX_CENTRAL_H

class OcspServers;

#include <NewPKI.h>
#include <ASN1/Asn1Resp.h>
#include "Conf.h"

#include <openssl/engine.h>

#include "SQL/SQL_Conn.h"
#include "SQL/SQL.h"

#include "Entity.h"
#include "SOCK_SERVER.h"
#include "Entity_SERVER.h"
#include <ASN1/Asn1Resp.h>
#include <openssl/ocsp.h>

/*!
	This class is the link between to servers and the entities.
*/
class PKIX_Central  
{
public:
	void PrintInfo(FILE * out);
	/*! \brief This is the constructor.
	 *  \param Conf [IN] The conf parsed from the config file.
	 *  \exception ExceptionNewPKI An error occured.
	 */
	PKIX_Central(const Config & Conf);

	/*! \brief This is the destructor.
	 */
	virtual ~PKIX_Central();
	
	/*! \brief This function is called on a new admin request.
	 *  \param response [OUT] The response.
	 *  \param ClientIp [IN] The IP of the client.
	 *  \param ClientCert [IN] The certificate of the client.
	 *  \param request [IN] The request.
	 *  \return true on success, false on failure.
	 */
	bool OnADMIN_REQUEST(AdminResponse & response, const char * ClientIp, const PKI_CERT & ClientCert, const AdminRequest & request);
	
	/*! \brief This function is called on a new OCSP request.
	 *  \param Ip [IN] The IP of the client.
	 *  \param request [IN] The OCSP request.
	 *  \param response [OUT] The OCSP response.
	 *  \param EntityName [IN] The name of the entity.
	 *  \param ShouldStopServer [OUT] The OCSP server should be stopped.
	 *  \return true on success, false on failure.
	 */
	bool OnNewOCSP(const char * Ip, OCSP_REQUEST * request, OCSP_RESPONSE ** response, const mString & EntityName, bool & ShouldStopServer);
	
	/*! \brief This function is called when a amin client closed the connection.
	 */
	void OnConnectionClosed();

	/*! \brief This function returns the SSL certificate.
	 *  \param SslCert [OUT] The SSL certificate.
	 */
	void GetSSL_Cert(PKI_CERT & SslCert);
	
	/*! \brief This function sets the OCSP server handler.
	 *  \param OcspServersHandler [IN/OUT] The OCSP server handler.
	 */
	void SetOcspServersHandler(OcspServers * OcspServersHandler);

private:
	void Clear();
	Config m_Conf;
	ENGINE * m_Engine;
	Entity_SERVER * LocalServer;
	AuthModule * m_AuthModule;
	bool LoadEngine(const mString & engine, const mString & EngineCmd);
};

#endif
