/* print.c - displays checksum listing
   
   Copyright (C) 2000 Bryan Call <bc@fodder.org>

   Modified by Jim Faulkner for newspost.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#include "../newspost.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include "cksfv.h"

void pnsfv_head(FILE *sfvfile)
{
  clock_t       clock;
  struct tm     *timeinfo;
  
  clock = time(NULL);
  timeinfo = localtime(&clock);
  fprintf(sfvfile,"; Generated by WIN-SFV32 v1.1a NOT! compatability line.\r\n");
  fprintf(sfvfile,"; Generated by newpost v%s on ", NVERSION);
  fprintf(sfvfile,"%02d-%02d-%02d at %02d:%02d.%02d\r\n", timeinfo->tm_year+1900,
         timeinfo->tm_mon, timeinfo->tm_mday, timeinfo->tm_hour,
         timeinfo->tm_min, timeinfo->tm_sec);
  fprintf(sfvfile,"; newspost written by Jim Faulkner <jfaulkne@ccs.neu.edu>\r\n");
  fprintf(sfvfile,"; cksfv written by Bryan Call <bc@fodder.org> ");
  fprintf(sfvfile,"- http://www.fodder.org/cksfv\r\n");
}

void pfileinfo(struct filell *firstfile,FILE *sfvfile)
{
  char          *fn;
  char		stripped[512];
  struct stat   sb;
  struct tm     *timeinfo;
  struct filell *loc = firstfile;
  
  fprintf(sfvfile,";\r\n");
 
  while(loc != NULL) {
    fn = loc->filename;
    strippath(fn,stripped);
    if (!(stat(fn, &sb))) {
      timeinfo = localtime(&sb.st_mtime);
      fprintf(sfvfile,";%13d  %02d:%02d.%02d %02d-%02d-%02d %s\r\n",
             (int)sb.st_size, timeinfo->tm_hour, timeinfo->tm_min,
             timeinfo->tm_sec,
             timeinfo->tm_year+1900, timeinfo->tm_mon, timeinfo->tm_mday, stripped);
    }
    loc = loc->next;
  }
}

#ifdef OSF
void pcrc(char *fn, unsigned int val, FILE *sfvfile)
#else
void pcrc(char *fn, unsigned long val, FILE *sfvfile)
#endif
{
  char stripped[512];
  strippath(fn,stripped);
#ifdef OSF
  fprintf(sfvfile,"%s %.8X\r\n", stripped, val);
#else
  fprintf(sfvfile,"%s %.8lX\r\n", stripped, val);
#endif
}

/*

void prsfv_head(char *fn, FILE *sfvfile)
{
  char          head[81], *p;
  int           len;
  
  fprintf(stderr, "cksfv v%s written by Bryan Call <bc@fodder.org>\r\n",
          VERSION);
  fprintf(stderr, "           http://www.fodder.org/cksfv\r\n\r\n");

  snprintf(head, 80, "--( Verifying: %s", fn);
  len = strlen(head);
  if (len < 76) {
    p = head + len;
    *p++ = ' ';
    *p++ = ')';
      
    for (p = head + len + 2, len = 78 - len; len--; p++)
      *p = '-';
  } else {
    p = head + 76;
    *p++ = ' ';
    *p++ = ')';
    *p++ = '-';
    *p++ = '-';
  }
  head[80] = '\r\n';
  head[81] = '\0';
  fprintf(stderr, "%s", head);
}

void pusage()
{
  fprintf(stderr, "cksfv v%s written by Bryan Call <bc@fodder.org>\r\n",
          VERSION);
  fprintf(stderr, "           http://www.fodder.org/cksfv\r\n\r\n");
  fprintf(stderr, "usage: cksfv [-iq] [-C directory] [-f file.sfv] ");
  fprintf(stderr, "[file ...]\r\nsupported options:\r\n\r\n");
  fprintf(stderr, " -C\tchange to directory for processing\r\n");
  fprintf(stderr, " -f\t.sfv file to verify\r\n");
  fprintf(stderr, " -i\tignore case on filenames\r\n");
  fprintf(stderr, " -q\tquiet, only prints error messages\r\n");
  fprintf(stderr, " -v\tverbose, by default this option is on\r\n");
  exit(1);
}

*/  
