/*  VER 009   TAB P   $Id: split.c,v 1.1 1999/04/25 07:02:03 src Exp $
 *
 *  split a file into argc/argv
 *
 *  copyright 1999 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: split.c,v $
 *  Revision 1.1  1999/04/25 07:02:03  src
 *  Added to CVS, it was omitted by mistake
 *
 */

#include "common.h"
#include "proto.h"

/*
 *  pick a line from an options file
 *
 *  the '#' introduces a comment
 *
 *  returns required when tokens continue
 */
static void
split_lines(char *line,char *envp[])
{
    int is_comment = 0;
    char *p;
    char *start = 0;
    int argc = 0;
    char **argv;
    int argc_max = 100;

    argv = xmalloc(argc_max*sizeof(char *));

    /* program name */
    argv[argc++] = pname;

    for (p = line; ;++p) {
	switch (*p) {
	case '\n':
	    is_comment = 0;
	case ' ':
	case '\t':
	    *p = '\0';
	    if (start) {
		if (argc >= argc_max-3) {
		    argc_max += 100;
		    argv = xrealloc(argv, argc_max*sizeof(char *));
		}
		argv[argc++] = start;
	    }
	    start = 0; /* start collecting again */
	    break;
	case '\\':
	    switch (p[1]) {
	    case '\n': 
		/* line continuation */
		if (!p[2]) {
		    *p = '\0';
		    goto done;
		}
		strcpy(p,p+2);
		--p;
		/* completely ignore backslash followed by newline */
		break;
	    case '\0': 
		goto done;
	    default:
		strcpy(p,p+1);
		if (!start && !is_comment) start = p;
		break;
	    }
	    break;
	case '\0':
	    goto done;
	case '#':
	    if (!start) ++is_comment;
	    break;
	default:
	    if (!start && !is_comment) start = p;
	    break;
	}
    }
  done:
    if (start) argv[argc++] = start;
    argv[argc] = NULL;
    if (argc > 1) pickargs(argc,argv,envp);
    free(argv);
}

/*
 *  split profile into arguments
 */
void
split_file(char *name,char *envp[],int complain)
{
    FILE *f;
    char *buf;
    long size = 0;

    if (!(f = fopen(name,"r"))) {
	if (complain) log_msg(L_ERRno,"can't open profile \"%s\"",name);
	else log_msg(L_DEBUG,"there is no %s, just ignore",name);
	return;
    }
    progtitle("reading profile");
    log_msg(L_DEBUG,"reading profile %s",name);

    if (!is_regular(f,name,&size)) {
	fclose(f);
	exit_cleanup(8);
    }

    buf = xmalloc(size+1);
    buf[size] = '\0';

    /* load local sys file */
    fread(buf,1,size,f);
    /* BUG: status... */

    fclose(f);

    split_lines(buf,envp);

    free(buf);
}

