/*  VER 064  TAB P   $Id: config.c,v 1.10.2.1 2002/01/29 06:44:48 egil Exp $
 *
 *  read news configuration file
 *
 *  NOTE: this is very ad-hoc.
 *        we don't intend to emulate a full shell here, just some
 *        essentials. this is not as bad as it sounds, since the
 *        typical news configuration is auto-generated, and reasonably
 *        well behaved.
 *
 *  copyright 1999 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: config.c,v $
 *  Revision 1.10.2.1  2002/01/29 06:44:48  egil
 *  Changing from xmalloc, xrealloc, xstrcpy to
 *  malloc_perfect, realloc_perfect and strdup_perfect
 *
 *  Revision 1.10  1999/04/19 03:32:38  src
 *  Standard profile in $PATHETC/newsx.conf
 *
 *  Revision 1.9  1999/04/08 10:48:53  src
 *  Extendeddbz to configure
 *
 *  Revision 1.8  1999/04/08 10:19:37  src
 *  Check for extendeddbz in configure
 *
 *  Revision 1.7  1999/04/08 07:31:28  src
 *  Support for a list of runtime configuration files.
 *
 *  Revision 1.6  1999/04/08 06:52:32  src
 *  Minor fixes
 *
 *  Revision 1.5  1999/04/08 06:31:08  src
 *  Support for full runtime configuration
 *
 *  Revision 1.4  1999/04/07 21:07:59  src
 *  Debugged config support
 *
 *  Revision 1.3  1999/04/07 20:09:16  src
 *  Implemented configuration reading, and eval mechanism
 *
 *  Revision 1.2  1999/03/11 07:30:00  src
 *  Implemented check for spool free space
 *
 *  Revision 1.1  1999/03/07 14:58:17  src
 *  Read newsconfig supported. Storage API supported.
 */

#include "common.h"
#include "proto.h"
#include "newsconfig.h"
#include "options.h"

/* 
 *  globals for config
 */
#define CONFIG_NAME 30

typedef struct config_s {
    struct config_s *next;
    char name[CONFIG_NAME+1];
    char val[1]; /* extend as required... */
} CONFIG_S;

#define CONFIG_HASH 127
CONFIG_S *config[CONFIG_HASH] = { 0 };

/*
 *  statics
 */
static int
load_1_config_f(FILE *f, char *configname);
static int
load_1_config(char *configname,int complain);

/*
 *  find tag from configuration
 */
static char *
find_config(char *tag)
{
    CONFIG_S *cp;
    long h = hashindex(tag,CONFIG_HASH);

    for (cp = config[h]; cp; cp = cp->next) {
	if (strcmp(cp->name,tag)==0) return cp->val;
    }
    return 0; /* not in list... */
}

/*
 *  add tag to config
 */
static void
config_tag(char *tag,char *val)
{
    int n; 
    CONFIG_S *cp;
    long h = hashindex(tag,CONFIG_HASH);

    if (!tag[0] || strlen(tag) > CONFIG_NAME) return;

    /* BUG: check if already? */
    n = sizeof(CONFIG_S) + strlen(val);

    cp = malloc_perfect(n);

    /* add to list of config tags at that hashindex */
    strcpy(cp->name,tag);
    strcpy(cp->val,val);
    cp->next = config[h];
    config[h] = cp;
}

/*
 *  verify config variable
 *  return true if we must copy
 */
static int
vfycfg(char *tag, char *oldval, char *newval)
{
    if (!newval) {
	log_msg(L_ERR,"missing config for %s, was \"%s\"",tag,oldval);
	return 0;
    }
    if (*newval == '`') {
	/* BUG: should support this, see config_eval() */
	log_msg(L_ERR,"non-supported config for %s: %s",tag,newval);
	return 0;
    }
    if (strcmp(oldval,newval) != 0) {
	if (verify_opt) {
	    log_msg(L_ERR,"altered config for %s: was \"%s\", is \"%s\"",
						    tag,oldval,newval);
	} else {
	    log_msg(L_DEBUG,"new config for %s: was \"%s\", is \"%s\"",
						    tag,oldval,newval);
	    return 1; /* update */
	}
    }
    return 0;
}

/*
 *  set config boolean variable
 */
static void
setcfgi(char *tag, int *oldvalp)
{
    char *newval = find_config(tag);
    if (newval) {
	int val = (strcmp(newval,"true")==0
		|| strcmp(newval,"yes")==0
		|| strcmp(newval,"on")==0);

	if (val != *oldvalp) {
	    if (verify_opt) {
		log_msg(L_ERR,"altered config for %s: was %d, is %d",
						    tag,*oldvalp,val);
	    } else {
		log_msg(L_DEBUG,"new config for %s: was %d, is %d",
						    tag,*oldvalp,val);
		*oldvalp = val; /* update */
	    }
	}
    }
}

/*
 *  set config string variable
 */
static void
setcfgf(char *tag, char **oldvalp)
{
    char *newval = find_config(tag);
    if (vfycfg(tag,*oldvalp,newval)) {
	*oldvalp = newval;
    }
}

/*
 *  set config variable from static buffer
 */
static void
setcfgb(char *tag, char **oldvalp, char *newval)
{
    if (vfycfg(tag,*oldvalp,newval)) {
	*oldvalp = strdup_perfect(newval);
    }
}

/*
 *  act upon config file
 */
static int
act_config(char *configname)
{
    char *p;
    char buf[PATH_MAX];

    if (find_config("INND")) {
	/*
	 *  must be INN
	 */
	inn_opt = 1;

	if (!find_config("NEWSBIN")) {
	    log_msg(L_ERR,"%s is probably in wrong format",configname);
	    return 0;
	}

	/* BUG: find_config("RNEWS") */
	/* BUG: INEWS */

	setcfgf("NEWSHOME",  &cfg_newshome);

	if (!(p = find_config("PATHETC"))) p = cfg_newshome;
	setcfgb("PATHETC",   &cfg_etc, p);

	setcfgf("NEWSBIN",   &cfg_newsbin);
	setcfgf("SPOOL",     &cfg_spool);
	setcfgf("BATCH",     &cfg_batch);
	setcfgf("INCOMING",  &cfg_incoming);

	strcpy(buf, cfg_spool);
	if ((p = strstr(buf,"/articles"))) {
	    /* BUG: trailing? */
	    /* new form (INN 2.0) */
	    strcpy(p,"/inhosts");
	} else {
	    /* old form */
	    build_filename(buf, cfg_spool,"/in.hosts",NULL,NULL);
	}
	setcfgb("INHOSTS",   &cfg_inhosts,    buf);

	setcfgf("ACTIVE",    &cfg_active);

	setcfgf("HISTORY",   &cfg_history);
#if 0
	BUG: DO_TAGGED_HASH
	    if test -f $HISTORY; then
	      if test -f $HISTORY.index; then
		  AC_MSG_RESULT($HISTORY, indexed hash)
	      elif test -f $HISTORY.pag; then
		  AC_DEFINE_UNQUOTED(DO_TAGGED_HASH, 1)
		  AC_MSG_RESULT($HISTORY, tagged hash)
	      else
		  AC_MSG_RESULT(ERROR: cannot determine hash mode of $HISTORY)
		  AC_MSG_RESULT(Try running makehistory first)
		  exit 1
	      fi
	  fi
	fi
#endif

	/* find_config("ERRLOG") */
	setcfgf("LOCKS",     &cfg_locks);
	setcfgf("NEWSFEEDS", &cfg_newsfeeds);

	/* setcfgf("NEWSUSER", NEWSUSER); */

	/* BUG: NEWSUMASK=`umask` */

	/* INN */
	setcfgi("EXTENDEDDBZ", &cfg_extendeddbz);
	setcfgi("STORAGEAPI",  &cfg_storageapi);

	/* BUG: move... */
	if (!cfg_storageapi) cfg_extendeddbz = 0;

    } else {
	/*
	 *  C news
	 */
	inn_opt = 0;
	if (!find_config("NEWSBIN")) {
	    log_msg(L_ERR,"%s is in wrong format",configname);
	    return 0;
	}
	setcfgf("NEWSBIN",   &cfg_newsbin);

	/* Convert to INN equivalents */
	/* BUG: RNEWS from NEWSBIN */
	/* BUG: INEWS */

	setcfgb("NEWSHOME",  &cfg_newshome,   find_config("NEWSCTL"));

	setcfgb("PATHETC",   &cfg_etc, cfg_newshome);

	setcfgb("SPOOL",     &cfg_spool,    find_config("NEWSARTS"));

	build_filename(buf, cfg_spool,"/out.going",NULL,NULL);
	setcfgb("BATCH",     &cfg_batch, buf);

	build_filename(buf, cfg_spool,"/in.coming",NULL,NULL);
	setcfgb("INCOMING",  &cfg_incoming, buf);

	build_filename(buf, cfg_spool,"/in.hosts", NULL,NULL);
	setcfgb("INHOSTS",   &cfg_inhosts, buf);

	/* pretty standard assumption: */
	build_filename(buf,  cfg_newshome,"/active",NULL,NULL);
	setcfgb("ACTIVE",    &cfg_active, buf);

	/* BUG: but this isn't always */
	build_filename(buf,  cfg_newshome,"/history",NULL,NULL);
	setcfgb("HISTORY",   &cfg_history, buf);

	/* BUG: find_config("ERRLOG") */

	setcfgb("LOCKS",     &cfg_locks,      find_config("NEWSCTL"));

	build_filename(buf, find_config("NEWSCTL"),"/sys",NULL,NULL);
	setcfgb("NEWSFEEDS", &cfg_newsfeeds, buf);

	/* BUG: strcpy(NEWSUSER, "news"); */
	/* BUG: NEWSUMASK */
    }
    return 1;
}

/*
 *  evaluate
 */
static int
config_eval(char *p)
{
    int ok;

    if (*p == '`') {
	FILE *f;
	int pid;
	int n;
	char *pgm = ++p;
	char *arg = NULL;

	while (*p) {
	    if (*p == ' ' || *p == '\t') {
		*p = '\0';
		arg = p+1;
		if ((p = strchr(arg,'\n'))) *p = '\0';
		if ((p = strchr(arg,'`'))) *p = '\0';
		break;
	    } else if (*p == '\n') {
		*p = '\0';
		break;
	    } else if (*p == '`') {
		*p = '\0';
		break;
	    }
	    ++p;
	}
	log_msg(L_DEBUG,"eval: %s %s",pgm,arg);

	/* must fork off a program here, and eval its output */
	f = fork_read(pgm,&pid,arg);

	ok = load_1_config_f(f,pgm);

	/* wait for child to finish */
	fclose(f);
	log_msg(L_DEBUGMORE,"wait pid %d...",pid);
	n = wait_pid(pid);
	log_msg(L_DEBUGMORE,"eval %s status is %d", pgm, n);
    } else {
	ok = load_1_config(p,1);
    }
    return ok;
}

/*
 *  load one config line
 */
static int
config_line(char *buf)
{
    int ok = 1;
    int is_more;
    int n;
    char *p;
    char *q;

    do {
	p = skipsp(buf);
	is_more = 0;

	if (p[0] && p[0] != '#') {
	    char tag[BUFSIZ];
	    char val[BUFSIZ];
	    tag[0] = '\0';
	    n = sscanf(p,"%[^ \n\t=]=%[^\n]",tag,val);
	    if (n == 2) {
		char realval[BUFSIZ];
		int is_quote = 0;
		char c;
		char *p = realval;
		q = val;

		if (*q == '"') {
		    is_quote = 1;
		    ++q;
		}

		/* BUG: what about ';'? */
		while ((c = *q++)) {
		    if (c == '$') {
			if (*q == '{') {
			    char *r,*s,*v;
			    if ((r = strchr(++q,'}'))) {
				/* expand ${xxx} */
				*r = '\0';
				if ((s = strchr(q,'-'))) {
				    /* expand ${XXX-default} */
				    *s++ = '\0';
				}
				if (!(v = find_config(q))) v = s;
				while (v && (c = *v++)) {
				    *p++ = c;
				    /* BUG: strlen */
				}
				q = r+1;
			    }
			}
		    } else if (c==';') {
			is_more = 1;
			buf = q;
			break;
		    } else if (is_quote && c=='"') {
			break;
		    } else {
			*p++ = c;
			/* BUG: strlen */
		    }
		}
		*p = '\0';

		config_tag(tag,realval);
		log_msg(L_DEBUGMORE,"conf: %s=\"%s\"",tag,realval);

	    } else if (strcmp(tag,"eval")==0) {
		p = skipsp(p + strlen(tag));
		ok = config_eval(p);

	    } else if (strcmp(tag,".")==0) {
		p = skipsp(p + strlen(tag));
		if ((q = strchr(p,' '))) *q = '\0';
		log_msg(L_DEBUG,"include: %s",p);

		/* read this file... */
		ok = load_1_config(p,1);

	    } else if (strcmp(tag,"umask")==0) {
		/* trick for INN */
		p = skipsp(p + strlen(tag));
		if ((q = strchr(p,'\n'))) *q = '\0';
		log_msg(L_DEBUGMORE,"umask: %s",p);

		config_tag("NEWSUMASK",p);

	    } else if (strcmp(tag,"export")==0) {
		/* ignore: harmless */

	    } else {
		p = skipsp(buf);
		if (*p && *p != '\n') {
		    if ((q = strchr(p,'\n'))) *q = '\0';
		    log_msg(L_DEBUG,"skip: %s",p);
		}
	    }
	}
    } while (ok && is_more);

    return ok;
}

/*
 *  load one config file (already opened)
 */
static int
load_1_config_f(FILE *f, char *configname)
{
    int ok = 1;
    char buf[BUFSIZ];
    static int recursion = 0;

    if (recursion >= 10) {
	log_msg(L_ERR,"too deep recursion for \"%s\"",configname);
	return 0;
    }
    ++recursion;

    /* load local config file */
    while (fgets(buf,BUFSIZ,f)) {
	if (!config_line(buf)) {
	    ok = 0;
	    break;
	}
    }
    --recursion;
    return ok;
}

/*
 *  load one config file
 */
static int
load_1_config(char *configname,int complain)
{
    FILE *f;
    int ok;

    if (!(f = fopen(configname,"r"))) {
	log_msg((complain ? L_ERRno : L_DEBUG),
		"can't open config in \"%s\"",configname);
	return 0;
    }
    log_msg(L_DEBUG,"reading %s",configname);

    ok = load_1_config_f(f,configname);
    fclose(f);

    return ok;
}

/*
 *  load any news system config file
 *  the argument can be a list of files, seperated by colons
 */
int
load_config(char *configname)
{
    char *p;
    progtitle("read config");

    while ((p=strchr(configname,':'))) {
	int len = p-configname;
	char name[PATH_MAX];
	if (len > 0 && len < PATH_MAX) {
	    memcpy(name,configname,len);
	    name[len] = '\0';

	    /* try this file */
	    if (load_1_config(name,0)) {
		return act_config(name);
	    }
	}
	configname = p+1;
    }

    if (!load_1_config(configname,1)) {
	exit_cleanup(8);
    }

    return act_config(configname);
}

