/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.typing;

import gnu.bytecode.Type;
import mlsub.typing.Constraint;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.lowlevel.Engine;
import nice.tools.code.SpecialArray;
import nice.tools.code.SpecialTypes;
import nice.tools.typing.Types;

public final class PrimitiveType {
    public static TypeConstructor byteTC;
    public static TypeConstructor charTC;
    public static TypeConstructor intTC;
    public static TypeConstructor longTC;
    public static TypeConstructor boolTC;
    public static TypeConstructor shortTC;
    public static TypeConstructor doubleTC;
    public static TypeConstructor floatTC;
    public static TypeConstructor arrayTC;
    public static TypeConstructor voidTC;
    public static Monotype byteType;
    public static Monotype charType;
    public static Monotype intType;
    public static Monotype longType;
    public static Monotype boolType;
    public static Monotype shortType;
    public static Monotype doubleType;
    public static Monotype floatType;
    public static Monotype voidType;
    public static Polytype voidPolytype;
    public static Polytype boolPolytype;
    public static Polytype charPolytype;
    public static Polytype bytePolytype;
    public static Polytype shortPolytype;
    public static Polytype intPolytype;
    public static Polytype longPolytype;
    public static Polytype doublePolytype;
    public static Polytype floatPolytype;
    private static Polytype objectPolytype;
    public static TypeConstructor maybeTC;
    public static TypeConstructor sureTC;
    public static TypeConstructor nullTC;
    public static TypeConstructor classTC;
    public static TypeConstructor collectionTC;
    public static TypeConstructor throwableTC;

    public static Type register(String name, TypeConstructor tc) {
        if (name.equals("nice.lang.char")) {
            charTC = tc;
            charType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            charPolytype = new Polytype(charType);
            return SpecialTypes.charType;
        }
        if (name.equals("nice.lang.byte")) {
            byteTC = tc;
            byteType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            bytePolytype = new Polytype(byteType);
            return SpecialTypes.byteType;
        }
        if (name.equals("nice.lang.short")) {
            shortTC = tc;
            shortType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            shortPolytype = new Polytype(shortType);
            return SpecialTypes.shortType;
        }
        if (name.equals("nice.lang.int")) {
            intTC = tc;
            intType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            intPolytype = new Polytype(intType);
            return SpecialTypes.intType;
        }
        if (name.equals("nice.lang.long")) {
            longTC = tc;
            longType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            longPolytype = new Polytype(longType);
            return SpecialTypes.longType;
        }
        if (name.equals("nice.lang.boolean")) {
            boolTC = tc;
            boolType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            boolPolytype = new Polytype(boolType);
            return SpecialTypes.booleanType;
        }
        if (name.equals("nice.lang.double")) {
            doubleTC = tc;
            doubleType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            doublePolytype = new Polytype(doubleType);
            return SpecialTypes.doubleType;
        }
        if (name.equals("nice.lang.float")) {
            floatTC = tc;
            floatType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            floatPolytype = new Polytype(floatType);
            return SpecialTypes.floatType;
        }
        if (name.equals("nice.lang.void")) {
            voidTC = tc;
            Engine.setTop(tc);
            voidType = Types.sureMonotype(new MonotypeConstructor(tc, null));
            voidPolytype = new Polytype(Constraint.True, voidType);
            return SpecialTypes.voidType;
        }
        if (name.equals("nice.lang.Array")) {
            arrayTC = tc;
            return SpecialArray.wrappedType();
        }
        if (name.equals("nice.lang.Maybe")) {
            maybeTC = tc;
            NullnessKind.setMaybe(tc);
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Sure")) {
            sureTC = tc;
            NullnessKind.setSure(tc);
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Null")) {
            nullTC = tc;
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Type")) {
            return Type.pointer_type;
        }
        return null;
    }

    public static Polytype objectPolytype() {
        if (objectPolytype == null) {
            objectPolytype = new Polytype(Constraint.True, Types.sureMonotype(TopMonotype.instance));
        }
        return objectPolytype;
    }

    public static void reset() {
        objectPolytype = null;
    }
}

