/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;

public class ArrayType
extends ObjectType {
    public Type elements;

    public ArrayType(Type elements) {
        this(elements, elements.getName() + "[]");
    }

    ArrayType(Type elements, String name) {
        this.this_name = name;
        this.setSignature("[" + elements.getSignature());
        this.elements = elements;
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public Type getImplementationType() {
        Type eltype = this.elements.getImplementationType();
        return this.elements == eltype ? this : ArrayType.make(eltype);
    }

    public static ArrayType make(Type elements) {
        String name = elements.getName() + "[]";
        ArrayType type = (ArrayType)Type.lookupType(name);
        if (type == null) {
            type = new ArrayType(elements, name);
            mapNameToType.put(name, type);
        }
        return type;
    }

    public Type getComponentType() {
        return this.elements;
    }

    @Override
    public String getInternalName() {
        return this.getSignature();
    }

    @Override
    public boolean isSubtype(Type other) {
        if (!(other instanceof ArrayType)) {
            return false;
        }
        Type otherElements = ((ArrayType)other).elements;
        return this.elements.isSubtype(otherElements);
    }

    @Override
    public int compare(Type other) {
        if (other == nullType) {
            return 1;
        }
        if (other instanceof ArrayType) {
            return this.elements.compare(((ArrayType)other).elements);
        }
        if (other.getName().equals("java.lang.Object")) {
            return -1;
        }
        return -3;
    }

    @Override
    public boolean isAssignableTo(Type other) {
        if (other == pointer_type || this == other) {
            return true;
        }
        if (!(other instanceof ArrayType)) {
            return false;
        }
        ArrayType o = (ArrayType)other;
        return this.elements.getSignature().equals(o.elements.getSignature());
    }

    @Override
    public void emitCoerceFrom(Type fromType, CodeAttr code) {
        if (!(fromType instanceof ArrayType)) {
            super.emitCoerceFrom(fromType, code);
            return;
        }
        Type from = ((ArrayType)fromType).elements;
        if (this.elements == from) {
            return;
        }
        if (!(this.elements instanceof PrimType) || !(from instanceof PrimType)) {
            return;
        }
        Scope scope = code.pushScope();
        Variable old = code.addLocal(fromType);
        code.emitStore(old);
        Variable newArray = code.addLocal(this);
        code.emitLoad(old);
        code.emitArrayLength();
        code.emitNewArray(this.elements, 1);
        code.emitStore(newArray);
        Variable elem = code.addLocal(Type.int_type);
        code.emitPushInt(0);
        code.emitStore(elem);
        Label test2 = new Label(code);
        Label copy2 = new Label(code);
        code.emitGoto(test2);
        copy2.define(code);
        code.emitLoad(newArray);
        code.emitLoad(elem);
        code.emitLoad(old);
        code.emitLoad(elem);
        code.emitArrayLoad(from);
        code.emitConvert(from, this.elements);
        code.emitArrayStore(this.elements);
        code.emitInc(elem, (short)1);
        test2.define(code);
        code.emitLoad(elem);
        code.emitLoad(old);
        code.emitArrayLength();
        code.emitGotoIfLt(copy2);
        code.emitLoad(newArray);
        code.popScope();
    }
}

