/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class SynchronizedExp
extends Expression {
    Expression object;
    Expression body;

    public SynchronizedExp(Expression object, Expression body) {
        this.object = object;
        this.body = body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Environment env) throws Throwable {
        Object value;
        Object object = value = this.object.eval(env);
        synchronized (object) {
            return this.body.eval(env);
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        CodeAttr code = comp.getCode();
        this.object.compile(comp, Target.pushObject);
        code.emitDup(1);
        Scope scope = code.pushScope();
        Variable objvar = scope.addVariable(code, Type.pointer_type, null);
        code.emitStore(objvar);
        code.emitMonitorEnter();
        code.emitTryStart(true, target instanceof IgnoreTarget || target instanceof ConsumerTarget ? null : target.getType());
        this.body.compileWithPosition(comp, target);
        code.emitTryEnd();
        code.emitFinallyStart();
        code.emitLoad(objvar);
        code.emitMonitorExit();
        code.emitFinallyEnd();
        code.emitTryCatchEnd();
        code.popScope();
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkSynchronizedExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.object = this.object.walk(walker);
        if (walker.exitValue == null) {
            this.body = this.body.walk(walker);
        }
    }

    @Override
    public void print(OutPort ps) {
        ps.print("(Synchronized ");
        this.object.print(ps);
        ps.print(" ");
        this.body.print(ps);
        ps.print(")");
    }
}

