/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.TrivialConstraint;

public class UnboundConstraint
extends Constraint {
    Environment environment;
    static UnboundConstraint instance;

    public static UnboundConstraint getInstance(Environment environment) {
        UnboundConstraint result;
        if (environment != null) {
            result = environment.unboundConstraint;
            if (result == null) {
                environment.unboundConstraint = result = new UnboundConstraint(environment);
            }
        } else {
            result = instance;
            if (result == null) {
                instance = result = new UnboundConstraint(null);
            }
        }
        return result;
    }

    public static UnboundConstraint getInstance(Binding binding) {
        Constraint constraint = binding.constraint;
        if (constraint instanceof UnboundConstraint) {
            return (UnboundConstraint)binding.constraint;
        }
        return UnboundConstraint.getInstance(constraint.getEnvironment(binding));
    }

    public UnboundConstraint(Environment environment) {
        this.environment = environment;
    }

    @Override
    public Object get(Binding binding, Object defaultValue) {
        Object value = binding.value;
        if (value == null && this.environment != null && this.environment.previous != null) {
            binding.value = value = this.environment.previous.lookup(binding.getName());
        }
        if (value != null) {
            return ((Binding)value).get();
        }
        return defaultValue;
    }

    @Override
    public boolean isBound(Binding binding) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Binding binding, Object value) {
        Environment env = this.getEnvironment(binding);
        if (env != null && env.locked) {
            throw new IllegalStateException("attempt to modify variable: " + binding.getName() + " locked environment");
        }
        Binding binding2 = binding;
        synchronized (binding2) {
            if (binding.constraint == this) {
                binding.setConstraint(TrivialConstraint.getInstance(env));
            }
            binding.constraint.set(binding, value);
        }
    }

    @Override
    public Environment getEnvironment(Binding binding) {
        return this.environment;
    }
}

