/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import java.lang.reflect.Array;
import nice.lang.inline.Tools;
import nice.tools.code.SpecialTypes;

public class ArrayGetOp
extends Procedure2
implements Inlineable {
    private final Type type;
    private final Target arrayTarget;
    private static Method reflectGet = ClassType.make("java.lang.reflect.Array").getDeclaredMethod("get", 2);

    public static ArrayGetOp create(String param) {
        Type type = Tools.type(param.charAt(0));
        if (type == null) {
            User.error("Unknown type in array read acces operator: " + param);
        }
        return new ArrayGetOp(type);
    }

    public ArrayGetOp(Type type) {
        this.type = type;
        this.arrayTarget = type != null ? new StackTarget(SpecialTypes.array(type)) : StackTarget.pushObject;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        args[0].compile(comp, this.arrayTarget);
        boolean bytecodeArray = Tools.monomorphicArray(code.topType());
        args[1].compile(comp, Tools.intTarget);
        if (bytecodeArray) {
            code.emitArrayLoad();
        } else {
            code.emitInvokeStatic(reflectGet);
        }
        target.compileFromStack(comp, code.topType());
    }

    @Override
    public Type getReturnType(Expression[] args) {
        Type array = args[0].getType();
        if (array instanceof ArrayType) {
            return ((ArrayType)array).getComponentType();
        }
        if (this.type != null) {
            return this.type;
        }
        return Type.pointer_type;
    }

    @Override
    public Object apply2(Object arg1, Object arg2) {
        return Array.get(arg1, ((Number)arg2).intValue());
    }
}

