/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.typing;

import gnu.bytecode.PrimType;
import mlsub.typing.BadSizeEx;
import mlsub.typing.Constraint;
import mlsub.typing.Domain;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import mlsub.typing.UnknownMonotype;
import mlsub.typing.lowlevel.Element;
import nice.tools.typing.PrimitiveType;

public final class Types {
    public static boolean isVoid(Monotype m) {
        return Types.equivalent(m).head() == PrimitiveType.voidTC;
    }

    public static boolean isVoid(Polytype t) {
        return Types.isVoid(t.getMonotype());
    }

    public static boolean isPrimitive(TypeConstructor tc) {
        return nice.tools.code.Types.javaType(tc) instanceof PrimType;
    }

    public static boolean isPrimitive(Monotype t) {
        return nice.tools.code.Types.javaType(t) instanceof PrimType;
    }

    public static boolean isPrimitive(Polytype t) {
        return nice.tools.code.Types.javaType(t) instanceof PrimType;
    }

    public static boolean isMaybe(Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.maybeTC;
    }

    public static boolean isSure(Monotype m) {
        return m instanceof MonotypeConstructor && ((MonotypeConstructor)m).getTC() == PrimitiveType.sureTC;
    }

    public static boolean isDispatchable(Monotype m) {
        if (Types.parameters(m) != null) {
            return false;
        }
        return !Types.isPrimitive(m);
    }

    public static Monotype equivalent(Monotype m) {
        return Types.rawType(m).equivalent();
    }

    public static void setMarkedKind(Monotype m) {
        m.setKind(NullnessKind.instance);
    }

    public static void makeMarkedType(MonotypeVar m) {
        m.setPersistentKind(NullnessKind.instance);
    }

    public static Monotype rawType(Monotype m) {
        if ((m = m.equivalent()).getKind() != NullnessKind.instance || m == UnknownMonotype.instance) {
            return m;
        }
        return ((MonotypeConstructor)m).getTP()[0];
    }

    public static Monotype rawType(MonotypeConstructor mc) {
        return mc.getTP()[0];
    }

    public static Monotype sureMonotype(Monotype type) {
        return new MonotypeConstructor(PrimitiveType.sureTC, new Monotype[]{type});
    }

    public static Monotype maybeMonotype(Monotype type) {
        return new MonotypeConstructor(PrimitiveType.maybeTC, new Monotype[]{type});
    }

    public static Monotype[] parameters(Monotype type) {
        return Types.rawType(type).domain();
    }

    public static Monotype[] parameters(Polytype type) {
        return Types.rawType(type.getMonotype()).domain();
    }

    public static Monotype result(Polytype type) {
        return ((FunType)Types.rawType(type.getMonotype())).codomain();
    }

    public static Monotype getTypeParameter(Polytype type, int rank) {
        type.simplify();
        return Types.getTypeParameter(type.getMonotype(), rank);
    }

    public static Polytype addSure(Polytype type) {
        return new Polytype(type.getConstraint(), Types.sureMonotype(type.getMonotype()));
    }

    public static TypeConstructor constructor(Monotype type) {
        return Types.equivalent(type).head();
    }

    public static TypeConstructor concreteConstructor(Monotype type) {
        TypeConstructor res = Types.constructor(type);
        if (res == null || res.isConcrete()) {
            return res;
        }
        return Typing.lowestInstance(res);
    }

    public static Monotype zeroArgMonotype(TypeConstructor tc) throws BadSizeEx {
        if (tc == PrimitiveType.classTC) {
            return new MonotypeConstructor(tc, new Monotype[]{UnknownMonotype.instance});
        }
        return new MonotypeConstructor(tc, null);
    }

    public static Monotype unknownArgsMonotype(TypeConstructor tc) throws BadSizeEx {
        if (tc.variance == null || tc.arity() == 0) {
            return new MonotypeConstructor(tc, null);
        }
        Monotype[] args = new Monotype[tc.arity()];
        for (int i = 0; i < tc.arity(); ++i) {
            args[i] = UnknownMonotype.instance;
        }
        return new MonotypeConstructor(tc, args);
    }

    public static Monotype getTypeParameter(Monotype type, int rank) {
        if (!((type = Types.rawType(type)) instanceof MonotypeConstructor)) {
            return null;
        }
        Monotype[] parameters = ((MonotypeConstructor)type).getTP();
        if (parameters == null || parameters.length <= rank) {
            return null;
        }
        return parameters[rank];
    }

    public static Domain domain(Polytype t) {
        Monotype[] m = Types.parameters(t.getMonotype());
        return new Domain(t.getConstraint(), m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean covariantSpecialization(Polytype spec, Polytype origin) {
        boolean entered = false;
        if (Constraint.hasBinders(spec.getConstraint()) || Constraint.hasBinders(origin.getConstraint())) {
            entered = true;
            Typing.enter();
        }
        try {
            try {
                if (entered) {
                    Polytype clonedSpec = spec.cloneType();
                    Constraint.enter(origin.getConstraint());
                    Constraint.enter(clonedSpec.getConstraint());
                    Element[] args = MonotypeVar.news(Types.parameters(origin).length);
                    Typing.introduce(args);
                    Typing.leq((Monotype[])args, Types.parameters(origin));
                    Typing.leq((Monotype[])args, Types.parameters(clonedSpec));
                    Typing.implies();
                    Constraint.enter(spec.getConstraint());
                    Typing.leq((Monotype[])args, Types.parameters(spec));
                }
                Typing.leq(Types.result(spec), Types.result(origin));
            }
            finally {
                if (entered) {
                    Typing.leave();
                }
            }
        }
        catch (TypingEx ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean domainsIntersect(Polytype t1, Polytype t2) {
        Typing.enter();
        try {
            try {
                Constraint.enter(t1.getConstraint());
                Constraint.enter(t2.getConstraint());
                Element[] args = MonotypeVar.news(Types.parameters(t2).length);
                Typing.introduce(args);
                Typing.leq((Monotype[])args, Types.parameters(t1));
                Typing.leq((Monotype[])args, Types.parameters(t2));
            }
            finally {
                Typing.leave();
            }
        }
        catch (TypingEx ex) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean typeParameterDispatch(Polytype spec, Polytype origin) {
        Monotype[] originalParams = Types.parameters(origin);
        if (originalParams.length == 0) {
            return false;
        }
        Typing.enter();
        try {
            try {
                Polytype clonedSpec = spec.cloneType();
                Constraint.enter(origin.getConstraint());
                Constraint.enter(clonedSpec.getConstraint());
                Element[] args = MonotypeVar.news(originalParams.length);
                Typing.introduce(args);
                Typing.leq((Monotype[])args, originalParams);
                Typing.leqHead((Monotype[])args, Types.parameters(clonedSpec));
                Typing.implies();
                Constraint.enter(spec.getConstraint());
                Typing.leq((Monotype[])args, Types.parameters(spec));
            }
            finally {
                Typing.leave();
            }
        }
        catch (TypingEx ex) {
            return true;
        }
        return false;
    }

    public static Monotype merge(Monotype m1, Monotype m2) {
        if (m1 == m2) {
            return m1;
        }
        Monotype raw = Types.rawMerge(Types.equivalent(m1), Types.equivalent(m2));
        if (raw == null) {
            return null;
        }
        TypeConstructor marker = Types.isSure(m1) && Types.isSure(m2) ? PrimitiveType.sureTC : PrimitiveType.maybeTC;
        MonotypeConstructor res = new MonotypeConstructor(marker, new Monotype[]{raw});
        return res;
    }

    private static Monotype rawMerge(Monotype raw1, Monotype raw2) {
        Monotype[] args;
        TypeConstructor head;
        if (raw1 == raw2) {
            return raw1;
        }
        if (raw1 == TopMonotype.instance || raw2 == TopMonotype.instance) {
            return TopMonotype.instance;
        }
        TypeConstructor head1 = raw1.head();
        TypeConstructor head2 = raw2.head();
        if (Typing.testRigidLeq(raw1.head(), raw2.head())) {
            head = raw2.head();
        } else if (Typing.testRigidLeq(raw2.head(), raw1.head())) {
            head = raw1.head();
        } else {
            return null;
        }
        Monotype[] args1 = ((MonotypeConstructor)raw1).getTP();
        Monotype[] args2 = ((MonotypeConstructor)raw2).getTP();
        if (args1 == null && args2 == null) {
            args = null;
        } else {
            args = new Monotype[args1.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Types.merge(args1[i], args2[i]);
                if (args[i] != null) continue;
                return null;
            }
        }
        return new MonotypeConstructor(head, args);
    }
}

