/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Objects
*/

#ifndef __OBJECTS_H_INCLUDED__
#define __OBJECTS_H_INCLUDED__

struct ObjectClass
{
	Sprite		*sprite;
	UScript		*initScript;
	UScript		*collideScript;
	UScript		*timerScript;
	uint		code;
	bool		bobbing;
};

struct Object
{
	struct MotionController	*mc;
	SlashTDP::Body		*body;
	ObjectClass		*oclass;
	SpriteState		*state;
	float			bobPos;
	int			bob;
	bool			visible;
	int			x;
	int			y;
	int			w;
	int			h;
	int			var[16];
	int			life;
	bool			deleteMe;
	bool			deleteMC;
	
	Object			*prev;
	Object			*next;
	
	Object(uint code);
	~Object();
	
	void setSprite(Sprite *sprite);
	
	void createMotionController();
	void createPhysicsController();
	
	void init();
	bool collision(Object *obj);
	bool collision(Tile *tile);
	void timer();
};

extern ObjectClass	**objectClass;
extern uint		objectClasses;

void initObjects();
void shutdownObjects();

ObjectClass *findObjectClass(uint code);

#endif

