
#include <sys/types.h>

#ifdef _THREAD_SAFE
# include <pthread.h>
#endif

struct nj_stats_light
{
	u_int total_user;	  /**< Total user memory ever requested */
	u_int total_faulted;  /**< Total memory faulted by system (pages present) */
	u_int peak_user;  	  /**< Peak user mem */
	u_int peak_faulted;   /**< Peak faulted mem */
	u_int peak_overhead;  /**< Peak overhead due to NJAMD */
	u_int total_allocs;   /**< Total number of allocation requests */
	u_int leaked_allocs;  /**< Total number of leaked allocs */
	u_long as_used;		  /**< Total amount of address space used */
};

/** Memory statistics data structure */
struct nj_stats
{
	u_int total_user;	  /**< Total user memory ever requested */
	u_int total_faulted;  /**< Total memory faulted by system (pages present) */
	u_int peak_user;  	  /**< Peak user mem */
	u_int peak_faulted;   /**< Peak faulted mem */
	u_int peak_overhead;  /**< Peak overhead due to NJAMD */
	u_int total_allocs;   /**< Total number of allocation requests */
	u_int leaked_allocs;  /**< Total number of leaked allocs */
	u_long as_used;		  /**< Total amount of address space used */
	u_int leaked_user;    /**< Leaked user memory */
	u_int leaked_faulted; /**< leaked memory faulted by system */
#ifdef _THREAD_SAFE
	pthead_mutex_t lock;  /**< Mutex lock */
#endif
};


