#include <signal.h>
#include <stdio.h>
#include <signal.h>

/* Define this to test NJAMD's signal handling capabilities from within GDB. */
#define GDB

int gotsig;

void sig_hdlr(int sig)
{
    fprintf(stderr, "We got a signal (%d)\n", sig);
    gotsig = sig;
}

void action_hdlr(int sig, siginfo_t *si, void *p)
{
    fprintf(stderr, "Giddie Up. We got some sweet sweet action (%d)\n", sig);
    gotsig = sig;
}

int main(int argc, char **argv)
{
    struct sigaction sa;
    int sig = 1;
    
    sa.sa_sigaction = action_hdlr;
    sa.sa_handler = sig_hdlr;
    sigemptyset(&sa.sa_mask);

    for(sig = 1; sig < 32; sig++)
    {
	switch(sig)
	{
		case SIGQUIT: 
		case SIGILL:  
		case SIGABRT:
		case SIGFPE:
		case SIGUSR1:
		case SIGSEGV:
		case SIGBUS:
#ifndef GDB
		case SIGINT:
#endif
		case SIGTERM:
			break;
		default:
			continue;
	
	}
	gotsig = 0;
	signal(sig, sig_hdlr);
	raise(sig);

	if(gotsig != sig)
	{
	    fprintf(stderr, "Failed to get sig %d\n", sig);
	    exit(sig);
	}

	sa.sa_flags = SA_RESTART | SA_SIGINFO;
	gotsig = 0;
	sa.sa_handler =0;
	sa.sa_sigaction = action_hdlr;
	sigaction(sig, &sa, NULL);
	raise(sig);

	if(gotsig != sig)
	{
	    fprintf(stderr, "Failed to get sig %d\n", sig);
	    exit(sig);
	}

	sa.sa_flags = 0;
	gotsig = 0;
	sa.sa_sigaction =0;
	sa.sa_handler =sig_hdlr;
	sigaction(sig, &sa, NULL);
	raise(sig);

	if(gotsig != sig)
	{
	    fprintf(stderr, "Failed to get sig %d\n", sig);
	    exit(sig);
	}	
	
    }
    exit(0);
    
}
