
/****** BEGIN USER CONFIGURATION SECTION *****/

/*
 * IMPORTANT: You should no longer need to edit this file to handle
 * your operating system. That should be handled and set correctly by
 * configure now.
 *
 * These are slowly being phased out, but currently
 * not everyone is auto-configured.  Then decide if you
 * wish to change the features that are compiled into nmh.
 */

/*
 * Turn on locale (setlocale) support
 */
#define LOCALE  1

/*
 * Define to 1 the type of file locking to use.  You need to
 * make sure the type of locking you use is compatible with
 * other programs which may modify your maildrops.
 * Currently you can only use one type.
 */
#undef DOT_LOCKING
#undef FCNTL_LOCKING
#undef LOCKF_LOCKING
#undef FLOCK_LOCKING

/*
 * If you have defined DOT_LOCKING, then the default is to
 * place the lock files in the same directory as the file that
 * is to be locked.  Alternately, if you define LOCKDIR, you
 * can specify that all lock files go in a specific directory.
 * Don't define this unless you know you need it.
 */
/* #define LOCKDIR "/usr/spool/locks" */

/*
 * Define this if your passwords are stored in some type of
 * distributed name service, such as NIS, or NIS+.
 */
#define DBMPWD  1

/*
 * Directs nmh not to try and rewrite addresses
 * to their official form.  You probably don't
 * want to change this without good reason.
 */
#define DUMB    1

/*
 * Define this if you do not want nmh to attach the local hostname
 * to local addresses.  You must also define DUMB.  You probably
 * don't need this unless you are behind a firewall.
 */
/* #define REALLYDUMB  1 */

/*
 * Starting on January 1, 2000, some MUAs like ELM and Ultrix's DXmail started
 * generated bad dates ("00" or "100" for the year).  If this #define is active,
 * we use windowing to correct those dates to what we presume to be the intended
 * values.  About the only time this could get us into trouble would be if a MUA
 * was generating a year of "00" in 2001 or later, due to an unrelated bug.  In
 * this case we would "correct" the year to 2000, which could result in
 * inaccurate bug reports against the offending MUA.  A much more esoteric case
 * in which you might not want to #define this would be if you were OCR'ing in
 * old written correspondence and saving it in email format, and you had dates
 * of 1899 or earlier.
 */
#define FIX_NON_Y2K_COMPLIANT_MUA_DATES 1

/*
 * Directs inc/slocal to extract the envelope sender from "From "
 * line.  If inc/slocal is saving message to folder, then this
 * sender information is then used to create a Return-Path
 * header which is then added to the message.
 */
#define RPATHS  1

/*
 * If defined, slocal will use `mbox' format when saving to
 * your standard mail spool.  If not defined, it will use
 * mmdf format.
 */
#define SLOCAL_MBOX  1

/*
 * If this is defined, nmh will recognize the ~ construct.
 */
#define MHRC    1

/*
 * Compile simple ftp client into mhn.  This will be used by mhn
 * for ftp access unless you have specified another access method
 * in your .mh_profile or mhn.defaults.  Use the "mhn-access-ftp"
 * profile entry to override this.  Check mhn(1) man page for
 * details.
 */
#define BUILTIN_FTP 1

/*
 * If you enable POP support, this is the the port name that nmh will use.  Make
 * sure this is defined in your /etc/services file (or its NIS/NIS+ equivalent).
 * If you are using KPOP, you will need to change this to "kpop" unless you want
 * to be able to use both POP3 _and_ Kerberized POP and plan to use inc and
 * msgchk's -kpop switch every time in the latter case.
 */
#define POPSERVICE "pop3"

/*
 * Define the default creation modes for folders and messages.
 */
#define DEFAULT_FOLDER_MODE "700"
#define DEFAULT_MESSAGE_MODE "600"

/*
 * Name of link to file to which you are replying.
 */
#define LINK "@"

/*
 * If wait/waitpid returns an int (no union wait).
 */
#define WAITINT 1

/* The following are autoconfigured, but you may wish to override the
 * decisions of autoconf (and AC_CANONICAL_SYSTEM) and do your own
 * thing. If so, you can modify the definitions. The Comments are as
 * useful as ever. */

/* these three are only used in vmh.c, which currently is not being
 * built anyway. -Doug */
/* Defined for Solaris 2.x, Irix, OSF/1, HP-UX, AIX, SCO5 */
#undef SYS5
/* Defined for Solaris 2.x, Irix, OSF/1, HP-UX, AIX */
#undef SVR4
/* Defined for SunOS 4, FreeBSD, NetBSD, OpenBSD, BSD/OS, Mac OS X/Rhapsody */
#undef BSD44

/* Defined for SunOS 4, FreeBSD, NetBSD, OpenBSD, BSD/OS, Mac OS X/Rhapsody 
 * -- does PicoBSD have uname? :) */
#undef BSD42

/* Defined for SCO5 */
#undef SCO_5_STDIO

/* This tells nmh to use the Linux _IO_*_ptr defines from libio.h */ 
#undef LINUX_STDIO


/***** END USER CONFIGURATION SECTION *****/
@TOP@

/*
 * The prefix which is prepended to the name of messages when they
 * are "removed" by rmm.  This should typically be `,' or `#'
 */
#define BACKUP_PREFIX ","

/*
 * Define this if you want SMTP (simple mail transport protocol)
 * support.  This is currently always enabled.
 */
#define SMTPMTS 1

/*
 * Define this to compile client-side support for pop into
 * inc and msgchk.  Do not change this value manually.  You
 * must run configure with the '--enable-pop' option to
 * correctly build the pop client support.
 */
#undef POP

/*
 * Define this to compile client-side support for apop into
 * inc and msgchk. Do not change this value manually. You
 * must run configure with the '--enable-apop' option to
 * correctly build the apop client support.
 */
#undef APOP

/*
 * Define this to compile client-side support for kpop
 * (kerberized pop) into inc and msgchk.  Do not change this
 * value manually.  You must run configure with the option
 * '--with-krb4=PREFIX' to correctly build the kpop client support.
 */
#undef KPOP

/*
 * Define this to "pop" when using Kerberos V4
 */
#undef KPOP_PRINCIPAL

/*
 * Define this to use the Cyrus SASL library for authentication of
 * POP and SMTP
 */
#undef CYRUS_SASL

/*
 * Define this to compile support for using Hesiod to locate
 * pop servers into inc and msgchk.  Do not change this value
 * manually.  You must run configure with the option
 * '--with-hesiod=PREFIX' to correctly build Hesiod support.
 */
#undef HESIOD

/*
 * Compile in support for the Emacs front-end mh-e.
 */
#undef MHE

/* Define to 1 if your termcap library has the ospeed variable */
#undef HAVE_OSPEED
/* Define to 1 if you have ospeed, but it is not defined in termcap.h */
#undef MUST_DEFINE_OSPEED

/* Define to 1 if tgetent() accepts NULL as a buffer */
#undef TGETENT_ACCEPTS_NULL

/* Define to 1 if you have reliable signals */
#undef RELIABLE_SIGNALS

/* Define to 1 if you use POSIX style signal handling */
#undef POSIX_SIGNALS
 
/* Define to 1 if you use BSD style signal handling (and can block signals) */
#undef BSD_SIGNALS
 
/* Define to 1 if you use SYS style signal handling (and can block signals) */
#undef SYSV_SIGNALS
 
/* Define to 1 if you have no signal blocking at all (bummer) */
#undef NO_SIGNAL_BLOCKING

/* Define to `unsigned int' if <sys/types.h> or <signal.h> doesn't define */
#undef sigset_t

/*
 * Define to 1 if your vi has ATT bug, such that it returns
 * non-zero exit codes on `pseudo-errors'.
 */
#undef ATTVIBUG

/*
 * Define to 1 if you need to make `inc' set-group-id because your mail spool is
 * not world writable.  There are no guarantees as to the safety of doing this,
 * but this #define will add some extra security checks.
 */
#undef MAILGROUP

/* Define if your system defines TIOCGWINSZ in sys/ioctl.h.  */
#undef GWINSZ_IN_SYS_IOCTL

/* Define if your system defines `struct winsize' in sys/ptem.h.  */
#undef WINSIZE_IN_PTEM

/* Define to 1 if struct tm has gmtoff */
#undef HAVE_TM_GMTOFF

/* Define to 1 if struct utmp has ut_type */
#undef HAVE_UTMP_UT_TYPE

/* Define if your system has sigsetjmp */
#undef HAVE_SIGSETJMP

/* Define if your system has mkstemp */
#undef HAVE_MKSTEMP

/* Define if your system has sethostent */
#undef HAVE_SETHOSTENT

/* Define if your system has gethostbyname */
#undef HAVE_GETHOSTBYNAME

/* Define if your system has netdb.h */
#undef HAVE_NETDB_H

/* Define if your system has db1/ndbm.h instead of ndbm.h (ppclinux) */
#undef HAVE_DB1_NDBM_H

/* Define to the header containing the declaration of initgroups() on your
   system, if any.  AIX 4.[13], SunOS 4.1.3, and ULTRIX 4.2A have the function
   in libc but don't have a declaration anywhere. */
#undef INITGROUPS_HEADER

/* Define if your system actually has a prototype for snprintf() in <stdio.h>
   (or a file it includes) rather than just having a "stealth" definition of it
   in libc.a the way AIX 4.1 does. */
#undef HAVE_SNPRINTF_PROTOTYPE
