'use strict';
require('../common');
var assert = require('assert');
var net = require('net');

var kPoolSize = 40 * 1024;
var data = 'あ'.repeat(kPoolSize);
var receivedSize = 0;
var encoding = 'UTF-8';

var server = net.createServer(function(socket) {
  socket.setEncoding(encoding);
  socket.on('data', function(data) {
    receivedSize += data.length;
  });
  socket.on('end', function() {
    socket.end();
  });
});

server.listen(0, function() {
  var client = net.createConnection(this.address().port);
  client.on('end', function() {
    server.close();
  });
  client.write(data, encoding);
  client.end();
});

process.on('exit', function() {
  assert.equal(receivedSize, kPoolSize);
});
