/* This is a *very* draft hack of xkbvleds and asmodem */
/* for switch Thai-English Keyboard */
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/XKBlib.h>
#include <X11/keysym.h>
#include <X11/extensions/shape.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include <X11/xpm.h>
#include "xmodifier.h"
#include "modeoff.xpm"
#include "modeon.xpm"
#include "modeoffp.xpm"
#include "modeonp.xpm"

typedef struct _XpmIcon {
    Pixmap pixmap;
    Pixmap mask;
    XpmAttributes attributes;
} XpmIcon;

XEvent Event;            
Display	*display;	 
XpmIcon modePic[4], *currentPic;

void	CreateWindow(Display *);
void	GetXPM();
void	RedrawWindow( XpmIcon *v);
Pixel	getColor(char *name);

Window	rootWin;
Window	iconWin;
Window	mainWin;
char	*Geometry= 0;
int     nowin;
GC	WinGC;

#define MAXLINE 1024

wwarning(const char *msg, ...)
{
    va_list args;
    char buf[MAXLINE];

    va_start(args, msg);

    vsprintf(buf, msg, args);
    strcat(buf,"\n");
    fflush(stdout);
    fputs("nonlock", stderr);
    fputs(" warning: ",stderr);
    fputs(buf, stderr);
    fflush(stdout);
    fflush(stderr);

    va_end(args);
}

void createWindows(char *argv, Display * display){
    unsigned int borderwidth = 1;
    char *wname = argv;
    XTextProperty name;
    XGCValues gcv;
    unsigned long gcm;

    int screen, dummy;	
    XSizeHints sizeHints;
    XWMHints wmHints;
    XClassHint classHint;   

    screen = DefaultScreen(display);
    rootWin = RootWindow(display, screen);

    GetXPM();

    sizeHints.flags= USSize|USPosition;
    sizeHints.x = 0;
    sizeHints.y = 0;	

    XWMGeometry(display, screen, Geometry, NULL, (borderwidth =1), &sizeHints,
            &sizeHints.x,&sizeHints.y,&sizeHints.width,
            &sizeHints.height, &dummy); 	
    sizeHints.width = modePic[0].attributes.width;
    sizeHints.height= modePic[0].attributes.height;        

    mainWin = XCreateSimpleWindow(display, RootWindow(display, screen),
            sizeHints.x,sizeHints.y,
            sizeHints.width, sizeHints.height,
            borderwidth, getColor("black"), getColor("white"));
    iconWin = XCreateSimpleWindow(display, mainWin,
            sizeHints.x,sizeHints.y,
            sizeHints.width,sizeHints.height,
            borderwidth, getColor("black"), getColor("white"));

    XSelectInput(display, mainWin, (ExposureMask | ButtonPressMask |
            ButtonReleaseMask | StructureNotifyMask));
    XSelectInput(display, iconWin, (ExposureMask | ButtonPressMask |
            ButtonReleaseMask | StructureNotifyMask));

    classHint.res_name =  "nonlock";
    classHint.res_class = "Nonlock";
    XSetClassHint(display, mainWin, &classHint);     
    XSetWMNormalHints(display, mainWin, &sizeHints);

    if (XStringListToTextProperty(&wname, 1, &name) ==0) 
    {
        fprintf(stderr, "nonlock: heh... can't allocate window name wah\n");
        exit(-1);
    }
    XSetWMName(display, mainWin, &name);

    /* Create WinGC */
    gcm = GCForeground|GCBackground|GCGraphicsExposures;
    gcv.foreground = getColor("black");
    gcv.background = getColor("white");
    gcv.graphics_exposures = True;
    WinGC = XCreateGC(display, rootWin, gcm, &gcv);  

    wmHints.initial_state = WithdrawnState;

    wmHints.window_group = mainWin;
    wmHints.flags = StateHint | (nowin?0:IconWindowHint) | IconPositionHint
        | (nowin?0:WindowGroupHint);

    wmHints.icon_window = iconWin;
    wmHints.icon_x = sizeHints.x;
    wmHints.icon_y = sizeHints.y;
    XSetWMHints(display, mainWin, &wmHints); 	
    XMapWindow(display, mainWin);
}



void GetXPM()
{
    char **picData[4];
    XWindowAttributes attributes;
    int Ret,i;

    picData[0]=modeoff_xpm;
    picData[1]=modeon_xpm;
    picData[2]=modeoffp_xpm;
    picData[3]=modeonp_xpm;

    XGetWindowAttributes(display, rootWin, &attributes);		

    for(i=0; i<4; i++) {
        modePic[i].attributes.valuemask |= (XpmReturnPixels | XpmReturnExtensions);
        Ret = XpmCreatePixmapFromData(display, rootWin,
                picData[i], &modePic[i].pixmap, 
                &modePic[i].mask, &modePic[i].attributes);
        if(Ret != XpmSuccess)
        {
            fprintf(stderr, "nonlock: hmm... not enough free color cells wah\n");
            exit(1);
        }
    }
}

void RedrawWindow(XpmIcon *Icon)
{		
    XShapeCombineMask(display, mainWin, ShapeBounding, 0, 0, 
            Icon->mask, ShapeSet);
    XShapeCombineMask(display, iconWin, ShapeBounding, 0, 0, 
            Icon->mask, ShapeSet);

    XSetClipOrigin(display, WinGC, 0, 0);
    XSetClipMask(display, WinGC, Icon->mask);

    XCopyArea(display,Icon->pixmap, mainWin, WinGC,
            0,0,Icon->attributes.width, Icon->attributes.height,0,0);
    XCopyArea(display,Icon->pixmap,iconWin,WinGC,
            0,0,Icon->attributes.width, Icon->attributes.height,0,0);
    XFlush(display);
}

Pixel getColor(char *ColorName) {
    XColor Color;
    XWindowAttributes attributes;

    XGetWindowAttributes(display,rootWin,&attributes);
    Color.pixel = 0;

    if (!XParseColor (display, attributes.colormap, ColorName, &Color)) 
        fprintf(stderr,"nonlock: can't parse %s\n", ColorName);
    else if(!XAllocColor (display, attributes.colormap, &Color)) 
        fprintf(stderr,"nonlock: can't allocate %s\n", ColorName);       

    return Color.pixel;
}

void helpme(){
    puts("\n  usage: nonlock [--nowin] [--help] [\"Key\"]");
    puts("  Key: could be");
    puts("    Control+F11");
    puts("    Mod1+F8");
    puts("    F2");
    puts("    grave\n\n");
}

int main(int argc, char **argv) {

    XkbStateRec	sr;
    int sink=0,i;

    char *kstring;
    KeySym ksym;
    KeyCode kcode;
    unsigned int modifier, xkbeventbase;

    display= XOpenDisplay(NULL);
    nowin= 0;
    for(i= 1; i < argc ; i++)
        if(!strcmp(argv[i], "--nowin")) {
            if(argc<3) {
                puts("--nowin needs at least a key to toggle.");
                exit(1);
            }
            nowin= 1;
        } else if(!strcmp(argv[i], "--help")) {
            helpme();
            exit(1);
        }
    createWindows(argv[0], display);
    if(!XkbQueryExtension(display, NULL, &xkbeventbase, NULL, NULL, NULL)) {
        puts("XKB is not supported");
        exit(1);
    }
    XSetCommand(display,mainWin,argv,argc); 
    XkbSelectEvents(display,XkbUseCoreKbd,
            XkbStateNotifyMask,
            XkbStateNotifyMask);
    XkbGetState(display,XkbUseCoreKbd,&sr);
    currentPic=sr.compat_state&32?&modePic[1]:&modePic[0];

    for(i=1;i<argc;i++) {
    if(!strcmp(argv[i], "--nowin")) continue;
    modifier=0;
    if (argc > 1) {
        char *b, *k;
        b=strdup(argv[i]);
        while ((k=strchr(b,'+'))!=NULL) {
            int mod;
            *k=0;
            mod = wXModifierFromKey(b);
            if(mod<0) {
                puts("invalid key modifier");
                helpme();
                exit(0);
            }
            modifier |= mod;
            b=k+1;
        }
        ksym = XStringToKeysym(b);
        if (ksym==NoSymbol) {
            puts("invalid key short cut");
            helpme();
            exit(0);
        }

        kcode = XKeysymToKeycode(display,ksym);
        if (!kcode) {
            puts("invalid key for short cut");
            helpme();
            exit(0);
        }

        XGrabKey(display, kcode, modifier, rootWin, False, GrabModeAsync, GrabModeAsync);
    }
    }

    for(;;) {
        XNextEvent(display,&Event);
        if (Event.type == xkbeventbase) {
            XkbGetState(display,XkbUseCoreKbd,&sr);
            if(sink) currentPic=sr.compat_state&32?&modePic[3]:&modePic[2];
            else currentPic=sr.compat_state&32?&modePic[1]:&modePic[0];
            RedrawWindow(currentPic);
        }
        else switch(Event.type){                    
            case NoExpose:
                break;
            case Expose:           /* Redraw window */
                if(Event.xexpose.count == 0)
                    RedrawWindow(currentPic);
                break;               
            case KeyPress:
            case ButtonPress:      /* Mouseclick */
                XkbGetState(display,XkbUseCoreKbd,&sr);
                XkbLockGroup(display,XkbUseCoreKbd,!((sr.compat_state>>5)&1));
                XkbGetState(display,XkbUseCoreKbd,&sr);
                sink=1;
                break;
            case KeyRelease:
            case ButtonRelease:      /* Mouseclick */
                sink=0;
                XkbGetState(display,XkbUseCoreKbd,&sr);
                currentPic=sr.compat_state&32?&modePic[1]:&modePic[0];
                RedrawWindow(currentPic);
                break;
            case DestroyNotify:    /* Destroy window */
                XFreeGC(display, WinGC);
                XDestroyWindow(display, mainWin);
                XDestroyWindow(display, iconWin);
                XCloseDisplay(display);                            
                exit(0);
                break;                  
        }

    }

BAIL:
    XCloseDisplay(display);
    display= NULL;
    return 0;
}
