/****************************************************************************/
/* |\   ======   /| **               MCL                ** |\   ======   /| */
/* |__\========/__| **       Masar Class Libraries      ** |__\========/__| */
/* |\            /| ** -------------------------------- ** |\            /| */
/* |  \        /  | **  Maurizio Sartori (c) 1998-2000  ** |  \        /  | */
/* |    \    /    | ** -------------------------------- ** |    \    /    | */
/* |    /=\/=\    | **            Written  by           ** |    /=\/=\    | */
/* |  /========\  | **     Maurizio Sartori 'masar'     ** |  /========\  | */
/* |/   ======   \| **     e-mail:  masar@libero.it     ** |/   ======   \| */
/****************************************************************************/
/*              This program comes with ABSOLUTELY NO WARRANTY              */
/*            for details refer to the GNU General Public License           */
/****************************************************************************/
/*\F $Id: strutil.hpp,v 1.16 2000/06/12 09:05:28 cvs Exp $
*****************************************************************************/
#ifndef  _MCL_UTIL_STRUTIL_H_
#define  _MCL_UTIL_STRUTIL_H_

#include <vector>
#include <string>
#include <hash_map>

#include <mcl/mcl.hpp>

/****************************************************************************/
/*                      String Manipulation Functions                       */
/****************************************************************************/

VECTOR<STRING> MclSplit (const STRING & str, CHAR chSep);
VECTOR<PCSZ>   MclSplitFast (PSZ str, CHAR chSep);

STRING MclJoin (const VECTOR<STRING> & aSplitted, CHAR chSep);
STRING MclJoin (const VECTOR<STRING> & aSplitted, CHAR chSep, CHAR chRepl);
STRING MclJoin (const VECTOR<PCSZ> & aSplitted, CHAR chSep);
STRING MclJoin (const VECTOR<PCSZ> & aSplitted, CHAR chSep, CHAR chRepl);

/****************************************************************************/

MCL_SIGN MclStrICmp (PCSZ pStr1, PCSZ pStr2);
MCL_SIGN MclStrICmp (PCSZ pStr1, PCSZ pStr2, INT iCount);

PCSZ MclStrSearchEnd (PCSZ pcszPattern, PCSZ pcszData);
PSZ  MclStrSearchEnd (PCSZ pcszPattern, PSZ pcszData);
BOOL MclStrSearchSkip (PCSZ pcszPattern, istream & isIStream);
BOOL MclStrSearchSkip (PCSZ pcszPattern,
                       istream & isIStream, ostream & osOStream);
BOOL MclStrSearchSkip (PCSZ pcszPattern, istream & isIStream,
                       STRING & strOut, INT iMaxLen = -1);

PSZ MclReadLineAlloc (istream & isIStream);

VOID MclDumpData (ULONG ulCount, const UINT8 * pBuffer,
                  ostream & osOStream, ULONG ulOffset = 0);

/****************************************************************************/

struct MclIdReplaceStrCmp
   {
   bool operator() (const STRING s1, const STRING s2) const
      {
      return (s1 == s2);
      }
   };

__STL_TEMPLATE_NULL struct hash<const STRING &> {
  size_t operator()(const STRING & x) const
     {
     return __stl_hash_string (x.c_str());
     }
  };

typedef HASH_MAP<STRING, STRING,
                 hash<const STRING &>, MclIdReplaceStrCmp>
           MCL_HASH_MAP_STR_STR;

MCL_APIRET MclIdReplace (istream & isIStream, ostream & osOStream,
                         const MCL_HASH_MAP_STR_STR & hashMap,
                         INT & iFound, INT & iReplaced,
                         PCSZ pcszPrefix, PCSZ pcszSuffix,
                         CHAR chIncludeChar);

/****************************************************************************/
/*                         class MCL_STRING_SEARCH                          */
/****************************************************************************/
class MCL_STRING_SEARCH
   {
   private:
      /**********************************************************************/
      /*                            Private Data                            */
      /**********************************************************************/
      PSZ ach_Pattern;
      INT ai_Status[CHAR_MAX+1];
      INT i_Len;

      /**********************************************************************/
      /*                         Private Functions                          */
      /**********************************************************************/
      MCL_STRING_SEARCH (const MCL_STRING_SEARCH & obj);         // Don't Use
      MCL_STRING_SEARCH & operator= (const MCL_STRING_SEARCH & obj);  // ""

   public:
      /**********************************************************************/
      /*                          Public Functions                          */
      /**********************************************************************/
      MCL_STRING_SEARCH (PCSZ pcszPattern = NULL);
      ~MCL_STRING_SEARCH (VOID);

      VOID Set (PCSZ pcszPattern);

      PCSZ Match (PCSZ pcszData);

   };  /* end-class MCL_STRING_SEARCH */

/****************************************************************************/

#include <mcl/util/strutil.hi>

/****************************************************************************/
#endif   // !defined (_MCL_UTIL_STRUTIL_H_)
