/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "JumpStmt.h"
#include "Bytecode.h"
#include "CheckState.h"
#include "Error.h"

const char *sNames[2] = {"break", "continue" };

JumpStmt::JumpStmt(int type, const LexLocation &loc)
{
	fType = type;
	fLocation = loc;
}


bool JumpStmt::Check(CheckState &state)
{
	if (state.fLoopDepth==0)
	{
		Error(kErr_NoLoop, sNames[fType]).Raise(&fLocation);
		return false;
	}
	
	fNullable = false;
	return true;
}


void JumpStmt::Emit(Bytecode &b)
{
	int label = (fType==kJump_Break) ? b.GetBreakLabel() : b.GetContinueLabel();
	b.AddJump(label);
}


JumpStmt* JumpStmt::Clone(Mapping *) const
{
	return new JumpStmt(fType, fLocation);
}
