/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __RCX_Constants_h
#define __RCX_Constants_h

// opcodes

// outputs
#define kRCX_OutputModeOp	0x21
#define kRCX_OutputPowerOp	0x13
#define kRCX_OutputDirOp	0xe1
// inputs
#define kRCX_InputModeOp	0x42
#define kRCX_InputTypeOp	0x32
// sound
#define kRCX_PlaySoundOp	0x51
#define kRCX_PlayToneOp		0x23
// control flow
#define kRCX_TestOp			0x95
#define kRCX_JumpOp			0x72
#define kRCX_SJumpOp		0x27
#define kRCX_SetLoopOp		0x82
#define kRCX_CheckLoopOp	0x92

// misc
#define kRCX_DelayOp		0x43
#define kRCX_DisplayOp		0x33
#define kRCX_VarOp(code)	(0x14 + ((code) * 16))
#define kRCX_SendMessage	0xb2
#define kRCX_StartTaskOp	0x71
#define kRCX_StopTaskOp		0x81
#define kRCX_StopAllOp		0x50
#define kRCX_ClearTimerOp	0xa1
#define kRCX_ClearMsgOp		0x90
#define kRCX_SendMsgOp		0xb2
#define kRCX_ClearSensorOp	0xd1
#define kRCX_GoSubOp		0x17
#define kRCX_SetDatalogOp	0x52
#define kRCX_DatalogOp		0x62
#define kRCX_UploadDatalogOp	0xa4

// special
#define kRCX_ReadOp			0x12
#define kRCX_UnlockOp		0x1d
#define kRCX_BeginTaskOp	0x25
#define kRCX_BeginSubOp		0x35
#define kRCX_DownloadOp		0x4d
#define kRCX_Message		0xf7
#define kRCX_DeleteTasksOp	0x40
#define kRCX_DeleteSubsOp	0x70
#define kRCX_BootModeOp		0x65
#define kRCX_BeginFirmwareOp 0x75
#define kRCX_EndFirmwareOp	0xad
#define kRCX_PingOp			0x10
#define kRCX_SelectProgramOp	0x91
#define kRCX_BatteryLevelOp	0x30
#define kRCX_SetWatchOp		0x22
#define kRCX_IRModeOp	0x31
#define kRCX_AutoOffOp	0xb1

// cybermaster ops
#define kRCX_DriveOp	0x41
#define kRCX_OnWaitOp	0xc2
#define kRCX_OnWaitDifferentOp	0x53
#define kRCX_ClearTachoOp	0x11

typedef enum
{
	kRCX_VariableType	 = 0,
	kRCX_TimerType,
	kRCX_ConstantType,
	kRCX_OutputStatusType,
	kRCX_RandomType,
	kRCX_TachCounterType,
	kRCX_TachSpeedType,
	kRCX_OutputCurrentType,
	kRCX_ProgramType,
	kRCX_InputValueType,
	kRCX_InputTypeType,
	kRCX_InputModeType,
	kRCX_InputRawType,
	kRCX_InputBooleanType,
	kRCX_WatchType,
	kRCX_MessageType,
	kRCX_AGCType
} RCX_ValueType;

typedef int RCX_Value;


#define RCX_VALUE(t, d)		(((int)(t) << 16) | ((d) & 0xffff))
#define RCX_VALUE_TYPE(v)	((RCX_ValueType)(((v)>>16) & 0xff))
#define RCX_VALUE_DATA(v)	((short)((v) & 0xffff))

typedef enum
{
	kRCX_SetVar = 0,
	kRCX_AddVar,
	kRCX_SubVar,
	kRCX_DivVar,
	kRCX_MulVar,
	kRCX_SgnVar,
	kRCX_AbsVar,
	kRCX_AndVar,
	kRCX_OrVar,
	kRCX_IllegalVar = -1
} RCX_VarCode;


typedef enum
{
	kRCX_OutputFloat = 0,
	kRCX_OutputOff = 0x40,
	kRCX_OutputOn = 0x80
} RCX_OutputMode;


typedef enum
{
	kRCX_OutputBackward = 0,
	kRCX_OutputToggle = 0x40,
	kRCX_OutputForward = 0x80
} RCX_OutputDir;


typedef enum
{
	kRCX_InputRaw = 0,
	kRCX_InputBoolean = 0x20,
	kRCX_InputEdgeCounter = 0x40,
	kRCX_InputPeriodicCounter = 0x60,
	kRCX_InputPercentage = 0x80,
	kRCX_InputCelcius = 0xa0,
	kRCX_InputFahrenheit = 0xc0,
	kRCX_InputAngle = 0xe0
} RCX_InputMode;

typedef enum
{
	kRCX_InputNone = 0,
	kRCX_InputSwitch,
	kRCX_InputTemp,
	kRCX_InputLight,
	kRCX_InputRotation,
	kRCX_InputID0,
	kRCX_InputID1,
	kRCX_InputID2
} RCX_InputType;


typedef enum
{
	kRCX_LessOrEqual = 0,
	kRCX_GreaterOrEqual,
	kRCX_NotEqualTo,
	kRCX_EqualTo
} RCX_Relation;


typedef enum
{
	kRCX_TaskFragment = 0,
	kRCX_SubFragment
} RCX_FragmentType;


#define kRCX_MaxTasks	10
#define kRCX_MaxSubs	8
#define kRCX_MaxTasks_CM	4
#define kRCX_MaxSubs_CM		4
#define kRCX_MaxVars	32

#endif
