#include "prototypes.h"
#ifdef WIN32
#include <windows.h>
#else
#include <stdio.h>
#include <stdarg.h>
#endif

void debug(const char *fmt,...)
{
#ifdef DEBUG
#ifdef WIN32
    char szTemp[512];
    va_list ap;
    va_start(ap, fmt);
    wvsprintf(szTemp, fmt, ap);
    OutputDebugString(szTemp);
    va_end(ap);
#else
    va_list ap;

    va_start(ap, fmt);
    vfprintf(stderr, fmt, ap);
    va_end(ap);
#endif
#else
    UNUSED(fmt);
#endif
}
