/*****************************************************************************




Saleem N. Bhatti
February 1993
*****************************************************************************/


#if defined(__GNUG__)
#include <std.h>
#elif defined(__cplusplus)
#include <stdlib.h>
#endif

#include <stdio.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <memory.h>
#include <errno.h>
#include <string.h>
#include "qfDES.h"

#if !defined(_a_)
#if defined(__STDC__) || defined(__cplusplus)
#define _a_(_args_) _args_
#else
#define _a_(_args_) ()
#endif
#endif

extern char *sys_errlist[];
extern char *optarg;
extern int optind, opterr;

int getArgs _a_((int argc, char **argv, char *key, char *iv, QFDES_mode *mode, QFDES_what *what));

void
usage()
{
    fprintf(stderr, "\n");
    fprintf(stderr, "   usage: qf-des <-k key | -p string> [-d] [-i iv | -s ivstring] [-m mode]\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "   -d switches to decryption\n");
    fprintf(stderr, "   key is a 16 hex digit DES key\n");
    fprintf(stderr, "   string (e.g a password) is used to construct the DES key\n");
    fprintf(stderr, "   iv is a 16 hex digit initialisation vector (default zero)\n");
    fprintf(stderr, "   ivstring is used as the initialisation vector\n");
    fprintf(stderr, "   mode is one of ecb, cbc, cfb or ofb (default cbc)\n");
    fprintf(stderr, "\n");
}

#define BUFFER_SIZE 8192 /* This must be a multiple of 8 */

#if defined(__STDC__) || defined(__cplusplus)
main(int argc, char *argv[])
#else
main(argc, argv)
int  argc;
char *argv[];
#endif
{
    int eofFlag = 0, errFlag = 0,
        r, w, sr, sw;
    QFDES_mode mode;
    QFDES_what what;
    char key[8], iv[8], buffer[BUFFER_SIZE];

    if (getArgs(argc, argv, key, iv, &mode, &what) != 0) {
        usage();
        exit(0);
    }

    /* Do it */
    while(!eofFlag && !errFlag) {

        /* check read */
        if ((r = read(fileno(stdin), (char *) buffer, BUFFER_SIZE)) < 0) {
            fprintf(stderr, "qf-des: read error %d - %s\n",
                    errno, sys_errlist[errno]);
            errFlag = 1; 
            continue;
        }
        else if (r != BUFFER_SIZE)  /* Check for last read */
            eofFlag = 1;

        /* add padding */
        if ((what == qfDES_encrypt) ||
            (mode == qfDES_cfb) || (mode == qfDES_ofb))
            sr = eofFlag ? (int) qfDES_insertPadding(buffer, r) : r;
        else sr = r;

        /* perform DES */
        qfDES(key, buffer, sr, what, mode, iv);

        /* remove padding */
        if ((mode == qfDES_cfb) || (mode == qfDES_ofb))
            sw = eofFlag ? r : sr;
        else if (what == qfDES_decrypt)
            sw = eofFlag ? (int) qfDES_plainTextSize(buffer, sr) : sr;
        else sw = sr;

        /* check write */
        if ((w = write(fileno(stdout), (char *) buffer, sw)) != sw) {
            if (sw < 0)
                fprintf(stderr, "qf-des: arfle barfle gloop?\n");

            if (w < 0)
                fprintf(stderr, "qf-des: write error %d - %s\n",
                        errno, sys_errlist[errno]);

            errFlag = 1;
            continue;
        }
    }

    return 0;
}

int
getArgs(int argc, char **argv, char *key, char *iv, QFDES_mode *mode, QFDES_what *what)
{
    register
    int dFlag = 0, kFlag = 0, pFlag = 0, iFlag = 0, sFlag = 0, mFlag = 0,
        errFlag = 0, eofFlag = 0,
        opt, n;
    char line[128];

    /* Zero buffers */
    memset((void *) key, 0, 8);
    memset((void *) iv, 0, 8);

    /* defaults */
    *what = qfDES_encrypt;
    *mode = qfDES_cbc;

    if (argc < 2)
        return -1;

    /* Find out what to do ... */
    while((opt = getopt(argc, argv, "dk:p:i:s:m:")) != -1) {

        switch (opt) {

        case ('d') : /* Descrypt */
            if (dFlag) {
                fprintf(stderr, "qf-des: specify -d only once\n");
                errFlag = 1;
            }
            else *what = qfDES_decrypt;
            dFlag = 1;
            break;

        case ('k') : /* Key as a hex number */
            if (kFlag) {
                fprintf(stderr, "qf-des: use -k only once\n");
                errFlag = 1;
            }
            else if (!pFlag) {
                if (strlen(optarg) != 16) {
                    fprintf(stderr, "qf_des: hex number requires 16 digits\n");
                    errFlag = 1;
                }
                else {
                    if (qfDES_hex2bin(optarg, key, 16) != 8) {
                        fprintf(stderr, "qf-des: bad hex number - %s\n",
                                optarg);
                        errFlag = 1;
                    }
                    memset((void *) optarg, 0, 16); /* destroy key */
                }
            }
            else {
                fprintf(stderr, "qf-des: can't use -k and -p together\n");
                errFlag = 1;
            }
            kFlag = 1;
            break;

        case ('p') : /* Key as a password/string */
            if (pFlag) {
                fprintf(stderr, "qf-des: use -p only once\n");
                errFlag = 1;
            }
            else if (!kFlag) {
                if ((n = strlen(optarg)) < 1) {
                    fprintf(stderr, "qf-key: string requires at least 1 character\n");
                    errFlag = 1;
                }
                else {
                    memcpy((void *) key, (void *) qfDES_str2key(optarg), 8);
                    memset((void *) optarg, 0, n); /* destroy key */
                }
            }
            else {
                fprintf(stderr, "qf-des: can't use -k and -p together\n");
                errFlag = 1;
            }
            pFlag = 1;
            break;

        case ('i') : /* IV as a hex number */
            if (iFlag) {
                fprintf(stderr, "qf-des: use -k only once\n");
                errFlag = 1;
            }
            else {
                if (strlen(optarg) != 16) {
                    fprintf(stderr, "qf_des: hex number requires 16 digits\n");
                    errFlag = 1;
                }
                else {
                    if (qfDES_hex2bin(optarg, iv, 16) != 8) {
                        fprintf(stderr, "qf-des: bad hex number - %s\n",
                                optarg);
                        errFlag = 1;
                    }
                    memset((void *) optarg, 0, 16); /* destroy IV */
                }
            }
            iFlag = 1;
            break;

        case ('s') : /* IV as a string */
            if (sFlag) {
                fprintf(stderr, "qf-des: use -s only once\n");
                errFlag = 1;
            }
            else if (!iFlag) {
                if ((n = strlen(optarg)) < 1) {
                    fprintf(stderr, "qf-des: ivstring requires at least one character\n");
                    errFlag = 1;
                }
                else {
                    memcpy((void *) iv, optarg, n);
                    memset((void *) optarg, 0, n); /* destroy IV */
                }
            }
            else {
                fprintf(stderr, "qf-des: can't use both -i and -s\n");
                errFlag = 1;
            }
            sFlag = 1;
            break;

        case ('m') : /* DES mode */
            if (mFlag) {
                fprintf(stderr, "qf-des: use -m only once\n");
                errFlag = 1;
            }
            else if (strcmp(optarg, "ecb") == 0) *mode = qfDES_ecb;
            else if (strcmp(optarg, "cbc") == 0) *mode = qfDES_cbc;
            else if (strcmp(optarg, "cfb") == 0) *mode = qfDES_cfb;
            else if (strcmp(optarg, "ofb") == 0) *mode = qfDES_ofb;
            else {
                fprintf(stderr, "qf-des: unknown DES mode - %s\n", optarg);
                errFlag = 1;
            }
            mFlag = 1;
            break;

        case ('?') :
        default    :
            errFlag = 1;
            break;
        }
    }

    if (!kFlag && !pFlag) {
        fprintf(stderr, "qf-des: no key specified\n");
        errFlag = 1;
    }

    if ((mode == qfDES_ecb) && (iFlag || sFlag))
        fprintf(stderr, "qf-des: ECB mode -- IV will not be used\n");

    return (errFlag ? -1 : 0);
}
