/*****************************************************************************




Saleem N. Bhatti
February 1993
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include "qfDES.h"

extern char *optarg;
extern int optind, opterr;

char *wordFile = "/usr/dict/words";

void
usage()
{
    fprintf(stderr, "\n");
    fprintf(stderr, "   usage: qf-key [-i] [-n nKeys]\n");
    fprintf(stderr, "   Generate (nKey) key(s) (or IV(s) if -i flag given)\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "   usage: qf-key [-i] -s string\n");
    fprintf(stderr, "   Convert string to a DES key (or IV if -i flag given)\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "   usage: qf-key -c key\n");
    fprintf(stderr, "   Perform checks on key\n");
    fprintf(stderr, "\n");
}

#if defined(__STDC__) || defined(__cplusplus)
main(int argc, char *argv[])
#else
main(argc, argv)
int  argc;
char *argv[];
#endif
{
    int opt, n = 1, nFlag = 0, iFlag = 0, sFlag = 0, cFlag = 0,
        errFlag = 0;
    char key[9];
    char buffer[17];
    
    while((opt = getopt(argc, argv, "in:s:c:")) != -1) {

        switch (opt) {

        case ('i') : /* Generate IV */
            if (cFlag) {
                fprintf(stderr, "qf-key: can't use -i and -c together\n");
                errFlag = 1;
            } else if (iFlag) {
                fprintf(stderr, "qf-key: use -i once only\n");
                errFlag = 1;
            }
            iFlag = 1;
            break;

        case ('n') : /* Number of keys/IVs to generate */
            if (cFlag) {
                fprintf(stderr, "qf-key: can't use -n and -c together\n");
                errFlag = 1;
            } else if (sFlag) {
                fprintf(stderr, "qf-key: can't use -s and -n together\n");
                errFlag = 1;
            }
            else if (nFlag) {
                fprintf(stderr, "qf-key: use -n once only\n");
                errFlag = 1;
            }
            else if ((n = atoi(optarg)) < 0) {
                fprintf(stderr, "qf-key: please give a positive number\n");
                errFlag = 1;
            }
            nFlag = 1;
            break;

        case ('s') : /* Convert a string */
            if (cFlag) {
                fprintf(stderr, "qf-key: can't use -s and -c together\n");
                errFlag = 1;
            } else if (sFlag) {
                fprintf(stderr, "qf_key: use -s once only\n");
                errFlag = 1;
            } else if ((n = strlen(optarg)) < 1) {
                fprintf(stderr, "qf_key: string must have at least one character\n");
                errFlag = 1;
            }
            else {
                memset((void *) key, 0, 8);
                memcpy((void *) key, (void *) optarg, n > 8 ? 8 : n);
                memset((void *) optarg, 0, n); /* destroy key/IV */
            }
            sFlag = 1;
            break;

        case ('c') :
            if (iFlag || nFlag || sFlag) {
                fprintf(stderr, "qf-key: use -c flag on its own\n");
                errFlag = 1;
            } else if (cFlag) {
                fprintf(stderr, "qf-key: use -c once only\n");
                errFlag = 1;
            } else if ((n = strlen(optarg)) != 16) {
                fprintf(stderr, "qf-key: key must be a 16 hex digit number\n");
                errFlag = 1;
            } else {
                memset((void *) buffer, 0, 17);
                memcpy((void *) buffer, (void *) optarg, 16);
                memset((void *) optarg, 0, 17); /* destroy key */
                if (qfDES_hex2bin(buffer, key, 16) != 8) {
                    fprintf(stderr, "qf-key: bad hex number - %s\n", buffer);
                    errFlag = 1;
                }
            }
            cFlag = 1;
            break;

        case ('?') :
        default    :
            errFlag = 1;
            break;
        }
    }

    if (errFlag) {
        usage();
        exit(0);
    }

    if (sFlag) {
        qfDES_bin2hex(iFlag ? key : qfDES_str2key((char *) key), buffer, 8);
        printf("%s\n", buffer);

    } else if (cFlag) {

        int c;

        /* Check parity */
        fprintf(stderr, "   Parity check : ");
        if (qfDES_checkParity(key, 8, qfDES_odd) == 0)
            fprintf(stderr, "odd\n");
        else if (qfDES_checkParity(key, 8, qfDES_even) == 0)
            fprintf(stderr, "even\n");
        else fprintf(stderr, "none\n");

        /* Check against weak keys */
        fprintf(stderr, "   Weak Keys    : ");
        if (qfDES_checkWeakKeys(key) == 0)
            fprintf(stderr, "ok\n");
        else
            fprintf(stderr, "key is a known weak key\n");

        /* Check for printable characters */
        fprintf(stderr, "   Byte check 1 : ");
        for(n = 0; n < 8; ++n) {
            c = (int) ((unsigned int) key[n]);
            if (isprint(c))
                fprintf(stderr, "\'%c\' ", c);
            else fprintf(stderr,". ");
        }
        fprintf(stderr, "\n");

        fprintf(stderr, "   Byte check 2 : ");
        for(n = 0; n < 8; ++n) {
            c = (int) ((unsigned int) key[n] & 0x7f);
            if (isprint(c))
                fprintf(stderr, "\'%c\' ", c);
            else fprintf(stderr,". ");
        }
        fprintf(stderr, "\n");

        fprintf(stderr, "   Byte check 3 : ");
        for(n = 0; n < 8; ++n) {
            c = (int) ((unsigned int) (key[n] & 0xfe) >> 1);
            if (isprint(c))
                fprintf(stderr, "\'%c\' ", c);
            else fprintf(stderr,". ");
        }
        fprintf(stderr, "\n");
    }

    else {
        while(n--) {
            qfDES_bin2hex(qfDES_generate(iFlag ? qfDES_iv : qfDES_key), buffer, 8);
            printf("%s\n", buffer);
        }
    }

    return 0;
}
