/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "prototypes.h"
extern queue rtxq;
extern queue sendq;
extern page *p;
block *find_block_by_id();
line *find_line_by_id();

void send_retransmissions(after_time)
struct timeval *after_time;
{
    block *b;
    line *l;
/*  print_ds(); */
    if (p->first_block == NULL) {	/* if page is empty */
	debug("ERROR: Retransmission requested from empty page\n");
	return;
    }
    b = p->first_block;
    while (b != NULL) {		/* check through each block */
	if (newer(&(b->last_mod), after_time)) {
	    /*this block has changes we need to send */
	    hold_key();
	    queue_packet_for_sending(b, b->blockid, &sendq, BLOCKMSG);
	    if ((b->first_line != NULL) && (b->status != DELETED)) {
		l = b->first_line;
		while (l != NULL) {	/* check through each line of the block */
		    if (newer(&(l->last_mod), after_time)) {
			hold_key();
			debug("sending %s >>%s<<\n", l->lineid, l->line_data);
			/*we need to send this line too */
			queue_packet_for_sending(l, l->lineid,
						 &sendq, LINEMSG);
		    }
		    l = l->next_line;
		}
	    }
	}
	b = b->next_block;
    }
}


void send_specific_retransmission(id)
char *id;
{
    line *l;
    ENTRY *item, searchitem;
    searchitem.key = id;
    item = (ENTRY *) hsearch(searchitem, FIND);
    if (item == NULL) {		/* if can't find the item that someone has specifically asked for retransmission */
	queue_packet_for_sending(NULL, id, &sendq, UNKNOWNLINEMSG);
	return;			/* send an 'unknown element' transmission */
    }
    l = (line *) (item->data);
    if (l->type == LINEMSG) {	/* if requested element is a line */
	hold_key();		/* sliding key set up */
	debug("queuing rtx line %s\n", l->lineid);
	queue_packet_for_sending(l, l->lineid,	/* queue packet */
				 &sendq, LINEMSG);
    } else {			/* else the requested element is a block */
	debug("queuing rtx block %s\n", ((block *) l)->blockid);
	hold_key();
	queue_packet_for_sending(l, ((block *) l)->blockid,
				 &sendq, BLOCKMSG);
    }
}

int print_ds()
{
    block *b;
    line *l;
    if (p->first_block == NULL) {
	debug("ERROR: printout requested from empty page\n");
	return -1;
    }
    b = p->first_block;
    while (b != NULL) {
	printf("blockid: %s\n", b->blockid);
	printf("no_of_lines: %d\n", b->no_of_lines);
	if (b->first_line != NULL) {
	    l = b->first_line;
	    while (l != NULL) {
		printf("lineid: %s\n%s\n", l->lineid, l->line_data);
		l = l->next_line;
	    }
	}
	b = b->next_block;
    }
    return 0;
}
