# -*- coding: utf-8 -*-

"""
Copyright(C) 2007-2008 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: ajax.py 12127 2008-01-10 16:49:59Z romain $
"""

from pages import BasePage
from frags import FragmentFactory
from nevow import tags, loaders, inevow
from sessions import getUserSession, getSession
from tools import getBacktrace
import random
from nevow.i18n import _

class FragmentPage(BasePage):
    """ This Page can be called with http://localhost:8080/nulog/frag/.
        Used with Ajax to get only one fragment.
    """

    docFactory = loaders.stan(tags.invisible(render=tags.directive('content')))

    def childFactory(self, ctx, childSegment):
        return FragmentPage(self.conf, self.langconfig, self.AvatarId, childSegment)

    def render_content(self, ctx, data):
        if not self.content:
            return _('Nothing')

        args = ctx.locate(inevow.IRequest).args
        args = dict((i, args[i][0]) for i in args)

        title = None
        img = None

        frag = FragmentFactory(ctx, 'table', self.content, title, self.conf.get('Links', 'url'), args, img,
                               switch=True, divid=False, save=True)
        return ctx.tag[frag]

class CommandPage(BasePage):

    class Session(BasePage):

        class reset(BasePage):

            docFactory = loaders.stan(tags.invisible(render=tags.directive('result')))

            def render_result(self, ctx, data):

                username = getSession(ctx).username
                # If we want to reset the session, we get the params
                # from 'default' user, and we reset username variable.
                session = getUserSession(ctx, 'default')
                session.username = username
                session.store()

                return 'RESETED'

        class addfrag(BasePage):
            """ Arguments:
                - page
                - frag
                - [args]
            """

            docFactory = loaders.stan(tags.invisible(render=tags.directive('result')))

            def render_result(self, ctx, data):

                session = getSession(ctx)

                try:
                    # We find a name.
                    fragment = session.frags[ctx.arg('frag')]
                    while True:
                        fragname = '%s_%s%d' % (ctx.arg('page'), fragment.function, random.randint(1,9999))
                        if not session.frags.has_key(fragname):
                            break

                    # We copy the fragment object as a new fragment.
                    session.frags[fragname] = fragment.copy()
                    args = ctx.locate(inevow.IRequest).args
                    args = dict((i, args[i][0]) for i in args)
                    args.pop('page')
                    args.pop('frag')
                    args['tiny'] = True

                    session.frags[fragname].args.update(args)
                    session.frags[fragname].args['title'] = None

                    # We add the fragment on side which have the less tables.
                    page = session.pages[ctx.arg('page')]
                    if len(page.frags[1]) < len(page.frags[0]):
                        page.frags[1] += [fragname]
                    else:
                        page.frags[0] += [fragname]

                    session.store()

                    return 'FRAG ADDED %s %s' % (ctx.arg('frag'), fragname)
                except:
                    print getBacktrace()
                    return 'ERROR'

        class modfrag(BasePage):
            """ Arguments:
                - frag
            """

            docFactory = loaders.stan(tags.invisible(render=tags.directive('result')))

            def render_result(self, ctx, data):

                session = getSession(ctx)

                try:
                    args = ctx.locate(inevow.IRequest).args
                    args = dict((i, args[i][0]) for i in args)
                    fragment = session.frags[args.pop('frag')]

                    for key, value in args.items():
                        fragment.args[key] = value

                    session.store()

                    return 'FRAG MODIFIED'
                except:
                    print getBacktrace()
                    return 'ERROR'

        class modfragpos(BasePage):
            """ Arguments:
                - page
                - frag
                - column
                - pos
            """

            docFactory = loaders.stan(tags.invisible(render=tags.directive('result')))

            def render_result(self, ctx, data):

                session = getSession(ctx)

                try:
                    args = ctx.locate(inevow.IRequest).args
                    args = dict((i, args[i][0]) for i in args)

                    try:
                        page = session.pages[args['page']]
                    except:
                        page = session.getIndexPage()
                    for col in page.frags:
                        if args['frag'] in col:
                            col.remove(args['frag'])

                    column = page.frags[int(args['column'])]
                    column.insert(int(args['pos']), args['frag'])

                    session.store()

                    return 'FRAGPOS MODIFIED'

                except:
                    print getBacktrace()
                    return 'ERROR'

        class remfrag(BasePage):
            """ Arguments:
                - page
                - frag
            """

            docFactory = loaders.stan(tags.invisible(render=tags.directive('result')))

            def render_result(self, ctx, data):
                session = getSession(ctx)

                try:
                    try:
                        session.pages[ctx.arg('page')].frags[0].remove(ctx.arg('frag'))
                    except:
                        session.pages[ctx.arg('page')].frags[1].remove(ctx.arg('frag'))

                    remove_fragment = True
                    for name, page in session.pages.items():
                        if ctx.arg('frag') in page.frags[0] or ctx.arg('frag') in page.frags[1]:
                            remove_fragment = False
                            break

                    if remove_fragment:
                        session.frags.pop(ctx.arg('frag'))

                    session.store()

                    return loaders.stan('FRAG REMOVED %s' % ctx.arg('frag'))
                except:
                    print getBacktrace()
                    return 'ERROR'

        def childFactory(self, ctx, childSegment):

            cmds = {'addfrag': self.addfrag,
                    'modfrag': self.modfrag,
                    'modfragpos': self.modfragpos,
                    'remfrag': self.remfrag,
                    'reset':   self.reset}

            if childSegment in cmds:
                return cmds[childSegment](self.conf, self.langconfig, self.AvatarId, childSegment)

            return BasePage.childFactory(self, ctx, childSegment)

    def childFactory(self, ctx, childSegment):

        d = {'session': CommandPage.Session}

        if childSegment in d:
            return d[childSegment](self.conf, self.langconfig, self.AvatarId, childSegment)

        return BasePage.childFactory(self, ctx, childSegment)
