/* NVTV null backend -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Null backend for testing/debugging/calculating without hardware present.
 *
 */

#include "backend.h"
#include "back_null.h"
#include "data.h"
#include "debug.h"

static ChipInfo null_chip_ph = {
  name: "<Null Philips chip>", chip: NV_PHILIPS, next: NULL
};
  
static ChipInfo null_chip_ch = {
  name: "<Null Chrontel chip>", chip: NV_CHRONTEL, next: &null_chip_ph
};
  
static ChipInfo null_chip_cx = {
  name: "<Null Conexant chip>", chip: NV_CONEXANT, next: &null_chip_ch
};
  
static ChipInfo null_chip_bt = {
  name: "<Null Brooktree chip>", chip: NV_BROOKTREE, next: &null_chip_cx
};
  
static CardInfo null_card = {
  name: "<Null card>", dev:NULL, reg_base:0x0, pci_id:0x0110,
  chips: &null_chip_bt, next: NULL
};

static DataFunc *bnull_data = NULL;

void bnull_openCard (CardPtr card)
{
  DPRINTF ("bnull_open\n");
  bnull_data = data_func (null_card.chips->chip);
}

void bnull_closeCard (void)
{
  DPRINTF ("bnull_close\n");
}

void bnull_probeChips (void)
{
  DPRINTF ("bnull_probe\n");
  bnull_data = data_func (null_card.chips->chip);
}

void bnull_setChip (ChipPtr chip, Bool init)
{
  DPRINTF ("bnull_setChip %s %i\n", chip->name, init);
  bnull_data = data_func (chip->chip);
}

void bnull_setSettings (NVSettings *set)
{
  DPRINTF ("bnull_setSettings\n");
}

void bnull_getSettings (NVSettings *set)
{
  DPRINTF ("bnull_getSettings\n");
}

void bnull_setMode (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv)
{
  DPRINTF ("bnull_setMode\n");
}

void bnull_getMode (NVCrtRegs *crt, NVTvRegs *tv)
{
  DPRINTF ("bnull_getMode\n");
}

void bnull_setModeSettings (int ModeFlags, NVCrtRegs *crt, 
			   NVTvRegs *tv, NVSettings *set)
{
  DPRINTF ("bnull_setModeSettings\n");
}

void bnull_setTestImage (NVTvRegs *tv, NVSettings *set)
{
  DPRINTF ("bnull_setTestImage\n");
}

long bnull_getStatus (int index)
{
  DPRINTF ("bnull_getStatus\n");
  return 0;
}

NVConnect bnull_getConnection (void)
{
  DPRINTF ("bnull_getConnection\n");
  return CONNECT_NONE;
}

Bool bnull_findBySize (NVSystem system, int xres, int yres, char *size, 
    NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv)
{
  NVMode *nvm;

  DPRINTF ("bnull_findBySize %i %i,%i %s\n", system, xres, yres, size);
  nvm = data_find (bnull_data->modes, system, xres, yres, size);
  if (!nvm) {
    return FALSE;
  } 
  *mode = *nvm;
  bnull_data->init (system, mode->tv);
  return TRUE;
}

Bool bnull_findByOverscan (NVSystem system, int xres, int yres, 
    double hoc, double voc, NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv)
{
  DPRINTF ("bnull_findByOC %i %i,%i\n", system, xres, yres);
  return FALSE;
}

BackFuncRec bnull_func = {
  openCard:         bnull_openCard,
  closeCard:        bnull_closeCard,
  probeChips:       bnull_probeChips,
  setChip:          bnull_setChip,
  setSettings:      bnull_setSettings,
  getSettings:      bnull_getSettings,
  setMode:          bnull_setMode,
  getMode:          bnull_getMode,
  setModeSettings:  bnull_setModeSettings,
  setTestImage:     bnull_setTestImage, 
  getStatus:        bnull_getStatus,    
  getConnection:    bnull_getConnection,
  findBySize:       bnull_findBySize, 
  findByOverscan:   bnull_findByOverscan
};

CardPtr back_null_init (void)
{
  backend = &bnull_func;
  return &null_card;
}

