/* NVTV null backend header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 * Contents:
 *
 * Header for null backend
 */

#ifndef _BACK_NULL_H
#define _BACK_NULL_H

#include "backend.h"

CardPtr back_null_init (void);

/* back_null methods */

void bnull_openCard (CardPtr card);
void bnull_closeCard (void);
void bnull_probeChips (void);
void bnull_setChip (ChipPtr chip, Bool init);
void bnull_setSettings (NVSettings *set);
void bnull_getSettings (NVSettings *set);
void bnull_setMode (int ModeFlags, NVCrtRegs *crt, NVTvRegs *tv);
void bnull_getMode (NVCrtRegs *crt, NVTvRegs *tv);
void bnull_setModeSettings (int ModeFlags, NVCrtRegs *crt, 
			   NVTvRegs *tv, NVSettings *set);
void bnull_setTestImage (NVTvRegs *tv, NVSettings *set);
long bnull_getStatus (int index);
NVConnect bnull_getConnection (void);
Bool bnull_findBySize (NVSystem system, int xres, int yres, char *size, 
    NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);
Bool bnull_findByOverscan (NVSystem system, int xres, int yres, 
    double hoc, double voc, NVMode *mode, NVCrtRegs *crt, NVTvRegs *tv);

#endif /* _BACK_NULL_H */

